/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.mathematics.metrics.implementations;

import de.bioforscher.singa.mathematics.exceptions.DegenerateCaseException;
import de.bioforscher.singa.mathematics.graphs.model.Graph;
import de.bioforscher.singa.mathematics.graphs.model.Node;
import de.bioforscher.singa.mathematics.metrics.model.Metric;
import java.util.HashMap;
import java.util.LinkedList;

public class ShortestPathMetric
implements Metric<Node<?, ?, ?>> {
    private final Graph<?, ?, ?> graph;

    public ShortestPathMetric(Graph<?, ?, ?> graph) {
        this.graph = graph;
    }

    @Override
    public double calculateDistance(Node<?, ?, ?> first, Node<?, ?, ?> second) {
        HashMap<Node, Integer> distance = new HashMap<Node, Integer>(this.graph.getNodes().size());
        if (!this.graph.containsNode(first) || !this.graph.containsNode(second)) {
            throw new DegenerateCaseException("The graph has to contain both nodes " + first + " and " + second + " in order to calculate the shortest path between both.");
        }
        if (first.equals(second)) {
            return 0.0;
        }
        LinkedList<Node> queue = new LinkedList<Node>();
        queue.offer(first);
        distance.put(first, 0);
        while (!queue.isEmpty()) {
            Node currentNode = (Node)queue.poll();
            for (Node adjacentNode : currentNode.getNeighbours()) {
                if (distance.containsKey(adjacentNode)) continue;
                if (adjacentNode.equals(second)) {
                    return (Integer)distance.get(currentNode) + 1;
                }
                distance.put(adjacentNode, (Integer)distance.get(currentNode) + 1);
                queue.offer(adjacentNode);
            }
        }
        return Double.POSITIVE_INFINITY;
    }
}

