/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.mathematics.metrics.implementations;

import de.bioforscher.singa.mathematics.concepts.MultiDimensional;
import de.bioforscher.singa.mathematics.exceptions.IncompatibleDimensionsException;
import de.bioforscher.singa.mathematics.metrics.model.Metric;
import de.bioforscher.singa.mathematics.vectors.Vector;

public class MinkowskiMetric<VectorType extends Vector>
implements Metric<VectorType> {
    private final double p;

    public MinkowskiMetric(double p) {
        this.p = p;
    }

    @Override
    public double calculateDistance(VectorType first, VectorType second) {
        if (first.hasSameDimensions(second)) {
            if (this.p == Double.POSITIVE_INFINITY) {
                return this.getMaximalDifference(first, second);
            }
            return this.getRegularMinkowskiDifference(first, second);
        }
        throw new IncompatibleDimensionsException((MultiDimensional<?>)first, (MultiDimensional<?>)second);
    }

    private double getRegularMinkowskiDifference(VectorType first, VectorType second) {
        double sum = 0.0;
        for (int i = 0; i < first.getDimension(); ++i) {
            sum += Math.pow(Math.abs(first.getElement(i) - second.getElement(i)), this.p);
        }
        return Math.pow(sum, 1.0 / this.p);
    }

    private double getMaximalDifference(VectorType first, VectorType second) {
        double maximalDistance = 0.0;
        for (int i = 0; i < first.getDimension(); ++i) {
            double currentDistance = Math.abs(first.getElement(i) - second.getElement(i));
            if (!(currentDistance > maximalDistance)) continue;
            maximalDistance = currentDistance;
        }
        return maximalDistance;
    }
}

