/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.mathematics.matrices;

import de.bioforscher.singa.mathematics.exceptions.MalformedMatrixException;
import de.bioforscher.singa.mathematics.matrices.FastMatrices;
import de.bioforscher.singa.mathematics.matrices.Matrix;
import de.bioforscher.singa.mathematics.matrices.SquareMatrix;
import de.bioforscher.singa.mathematics.vectors.RegularVector;

public class SymmetricMatrix
extends SquareMatrix {
    private static final long serialVersionUID = -6578419947334743873L;

    public SymmetricMatrix(double[][] values) {
        super(values, true);
    }

    SymmetricMatrix(double[][] values, int rowDimension, int columnDimension) {
        super(values, rowDimension, columnDimension);
    }

    public static boolean isSymmetric(double[][] potentialValues) {
        if (!SymmetricMatrix.isSquare(potentialValues)) {
            return false;
        }
        for (int rowIndex = 0; rowIndex < potentialValues.length; ++rowIndex) {
            for (int columnIndex = 0; columnIndex < potentialValues[0].length; ++columnIndex) {
                if (potentialValues[columnIndex][rowIndex] == potentialValues[rowIndex][columnIndex]) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isSymmetric(Matrix matrix) {
        return SymmetricMatrix.isSymmetric(matrix.getElements());
    }

    public static void assertThatValuesAreSymmetric(double[][] potentialValues) {
        if (!SymmetricMatrix.isSymmetric(potentialValues)) {
            throw new MalformedMatrixException(potentialValues);
        }
    }

    public static boolean isCompact(double[][] potentialValues) {
        int rowLength = 1;
        for (double[] potentialValue : potentialValues) {
            if (potentialValue.length != rowLength) {
                return false;
            }
            ++rowLength;
        }
        return true;
    }

    public static double[][] compactToSymmetricMatrix(double[][] potentialValues) {
        int rowIndex;
        SymmetricMatrix.assertThatValuesAreSymmetric(potentialValues);
        double[][] compactedValues = new double[potentialValues.length][];
        for (rowIndex = 0; rowIndex < potentialValues.length; ++rowIndex) {
            compactedValues[rowIndex] = new double[rowIndex + 1];
        }
        for (rowIndex = 0; rowIndex < potentialValues.length; ++rowIndex) {
            System.arraycopy(potentialValues[rowIndex], 0, compactedValues[rowIndex], 0, rowIndex + 1);
        }
        return compactedValues;
    }

    @Override
    public RegularVector getColumn(int columnIndex) {
        return this.getRow(columnIndex);
    }

    @Override
    public RegularVector getRow(int rowIndex) {
        double[] rowElements = new double[this.getRowDimension()];
        System.arraycopy(this.getElements()[rowIndex], 0, rowElements, 0, rowIndex + 1);
        for (int j = rowIndex + 1; j < this.getRowDimension(); ++j) {
            rowElements[j] = this.getElements()[j][rowIndex];
        }
        return new RegularVector(rowElements);
    }

    @Override
    public double getElement(int rowIndex, int columnIndex) {
        if (rowIndex >= columnIndex) {
            return super.getElement(rowIndex, columnIndex);
        }
        return super.getElement(columnIndex, rowIndex);
    }

    public double[][] getCompleteElements() {
        double[][] values = new double[this.getRowDimension()][this.getColumnDimension()];
        for (int rowIndex = 0; rowIndex < this.getRowDimension(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < this.getColumnDimension(); ++columnIndex) {
                values[rowIndex][columnIndex] = this.getElement(rowIndex, columnIndex);
            }
        }
        return values;
    }

    @Override
    public Matrix transpose() {
        return FastMatrices.createSymmetricMatrix(this.getElements());
    }
}

