/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.mathematics.matrices;

import de.bioforscher.singa.mathematics.exceptions.MalformedMatrixException;
import de.bioforscher.singa.mathematics.matrices.FastMatrices;
import de.bioforscher.singa.mathematics.matrices.Matrix;
import de.bioforscher.singa.mathematics.matrices.SquareMatrix;
import de.bioforscher.singa.mathematics.matrices.SymmetricMatrix;
import de.bioforscher.singa.mathematics.vectors.RegularVector;
import de.bioforscher.singa.mathematics.vectors.Vector;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;

public class RegularMatrix
implements Matrix,
Serializable {
    private static final long serialVersionUID = -3809415443253404586L;
    private final double[][] elements;
    private final int rowDimension;
    private final int columnDimension;

    public RegularMatrix(double[][] values) {
        this(values, false);
    }

    protected RegularMatrix(double[][] values, boolean isSymmetric) {
        if (!isSymmetric) {
            if (!RegularMatrix.isWellFormed(values)) {
                throw new MalformedMatrixException(values);
            }
            this.elements = values;
            this.rowDimension = values.length;
            this.columnDimension = values[0].length;
        } else {
            if (SymmetricMatrix.isCompact(values)) {
                this.elements = values;
            } else {
                if (!RegularMatrix.isWellFormed(values)) {
                    throw new MalformedMatrixException(values);
                }
                this.elements = SymmetricMatrix.compactToSymmetricMatrix(values);
            }
            this.columnDimension = this.rowDimension = values.length;
        }
    }

    RegularMatrix(double[][] values, int rowDimension, int columnDimension) {
        this.elements = values;
        this.rowDimension = rowDimension;
        this.columnDimension = columnDimension;
    }

    private static <MatrixClass extends Matrix> MatrixClass createNewMatrix(double[][] values, Class<MatrixClass> matrixClass) {
        try {
            return (MatrixClass)((Matrix)matrixClass.getConstructor(double[][].class).newInstance(new Object[]{values}));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isWellFormed(double[][] potentialValues) {
        int requiredLength = potentialValues[0].length;
        for (int rowIndex = 1; rowIndex < potentialValues.length; ++rowIndex) {
            if (potentialValues[rowIndex].length == requiredLength) continue;
            return false;
        }
        return true;
    }

    public <MatrixClass extends Matrix> MatrixClass as(Class<MatrixClass> matrixClass) {
        if (this.getClass().equals(matrixClass)) {
            return (MatrixClass)((Matrix)matrixClass.cast(this));
        }
        if (SquareMatrix.isSquare(this) && matrixClass.getSimpleName().equals("SquareMatrix")) {
            return RegularMatrix.createNewMatrix(this.getElements(), matrixClass);
        }
        if (SymmetricMatrix.isSymmetric(this) && matrixClass.getSimpleName().equals("SymmetricMatrix")) {
            return RegularMatrix.createNewMatrix(this.getElements(), matrixClass);
        }
        throw new IllegalArgumentException("Could not create desired matrix, from this instance.");
    }

    @Override
    public String getDimensionAsString() {
        return String.valueOf(this.getRowDimension()) + "x" + String.valueOf(this.getColumnDimension());
    }

    @Override
    public double getElement(int rowIndex, int columnIndex) {
        return this.elements[rowIndex][columnIndex];
    }

    @Override
    public double[][] getElements() {
        return this.elements;
    }

    @Override
    public RegularVector getRow(int rowIndex) {
        return new RegularVector(this.elements[rowIndex]);
    }

    @Override
    public int getRowDimension() {
        return this.rowDimension;
    }

    @Override
    public RegularVector getColumn(int columnIndex) {
        double[] columnValues = new double[this.getRowDimension()];
        for (int rowIndex = 0; rowIndex < this.getRowDimension(); ++rowIndex) {
            columnValues[rowIndex] = this.elements[rowIndex][columnIndex];
        }
        return new RegularVector(columnValues);
    }

    @Override
    public int getColumnDimension() {
        return this.columnDimension;
    }

    @Override
    public Matrix add(Matrix summand) {
        this.assertThatDimensionsMatch(summand);
        double[][] values = new double[this.getRowDimension()][this.getColumnDimension()];
        for (int rowIndex = 0; rowIndex < this.getRowDimension(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < this.getColumnDimension(); ++columnIndex) {
                values[rowIndex][columnIndex] = this.getElement(rowIndex, columnIndex) + summand.getElement(rowIndex, columnIndex);
            }
        }
        return FastMatrices.createRegularMatrix(values);
    }

    @Override
    public Matrix subtract(Matrix subtrahend) {
        this.assertThatDimensionsMatch(subtrahend);
        double[][] values = new double[this.getRowDimension()][this.getColumnDimension()];
        for (int rowIndex = 0; rowIndex < this.getRowDimension(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < this.getColumnDimension(); ++columnIndex) {
                values[rowIndex][columnIndex] = this.getElement(rowIndex, columnIndex) - subtrahend.getElement(rowIndex, columnIndex);
            }
        }
        return FastMatrices.createRegularMatrix(values);
    }

    @Override
    public Matrix multiply(double multiplicand) {
        double[][] values = new double[this.getRowDimension()][this.getColumnDimension()];
        for (int rowIndex = 0; rowIndex < this.getRowDimension(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < this.getColumnDimension(); ++columnIndex) {
                values[rowIndex][columnIndex] = this.getElement(rowIndex, columnIndex) * multiplicand;
            }
        }
        return FastMatrices.createRegularMatrix(values);
    }

    @Override
    public Vector multiply(Vector multiplicand) {
        this.assertThatInnerDimensionsMatch(multiplicand);
        double[] values = new double[this.getRowDimension()];
        for (int matrixRowIndex = 0; matrixRowIndex < this.getRowDimension(); ++matrixRowIndex) {
            for (int vectorColumnIndex = 0; vectorColumnIndex < multiplicand.getDimension(); ++vectorColumnIndex) {
                int n = matrixRowIndex;
                values[n] = values[n] + multiplicand.getElement(vectorColumnIndex) * this.getElement(matrixRowIndex, vectorColumnIndex);
            }
        }
        return new RegularVector(values);
    }

    @Override
    public Matrix multiply(Matrix multiplicand) {
        this.assertThatInnerDimensionsMatch(multiplicand);
        double[][] values = new double[this.getRowDimension()][multiplicand.getColumnDimension()];
        for (int multiplierRowIndex = 0; multiplierRowIndex < this.getRowDimension(); ++multiplierRowIndex) {
            for (int multiplicandColumnIndex = 0; multiplicandColumnIndex < multiplicand.getColumnDimension(); ++multiplicandColumnIndex) {
                for (int multiplierColumnIndex = 0; multiplierColumnIndex < this.getColumnDimension(); ++multiplierColumnIndex) {
                    double[] dArray = values[multiplierRowIndex];
                    int n = multiplicandColumnIndex;
                    dArray[n] = dArray[n] + this.getElement(multiplierRowIndex, multiplierColumnIndex) * multiplicand.getElement(multiplierColumnIndex, multiplicandColumnIndex);
                }
            }
        }
        return FastMatrices.createRegularMatrix(values);
    }

    @Override
    public Matrix hadamardMultiply(Matrix multiplicand) {
        this.assertThatDimensionsMatch(multiplicand);
        double[][] values = new double[this.getRowDimension()][this.getColumnDimension()];
        for (int rowIndex = 0; rowIndex < this.getRowDimension(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < this.getColumnDimension(); ++columnIndex) {
                values[rowIndex][columnIndex] = this.getElement(rowIndex, columnIndex) * multiplicand.getElement(rowIndex, columnIndex);
            }
        }
        return FastMatrices.createRegularMatrix(values);
    }

    @Override
    public Matrix additivelyInvert() {
        double[][] values = new double[this.getRowDimension()][this.getColumnDimension()];
        for (int rowIndex = 0; rowIndex < this.getRowDimension(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < this.getColumnDimension(); ++columnIndex) {
                values[rowIndex][columnIndex] = -this.getElement(rowIndex, columnIndex);
            }
        }
        return FastMatrices.createRegularMatrix(values);
    }

    @Override
    public Matrix transpose() {
        double[][] values = new double[this.getColumnDimension()][this.getRowDimension()];
        for (int rowIndex = 0; rowIndex < this.getRowDimension(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < this.getColumnDimension(); ++columnIndex) {
                values[columnIndex][rowIndex] = this.getElement(rowIndex, columnIndex);
            }
        }
        return FastMatrices.createRegularMatrix(values);
    }

    public String toString() {
        int columnIndex;
        int rowIndex;
        StringBuffer resultString = new StringBuffer();
        int cols = this.getColumnDimension();
        int rows = this.getRowDimension();
        String[][] cells = new String[rows][];
        for (int rowIndex2 = 0; rowIndex2 < rows; ++rowIndex2) {
            cells[rowIndex2] = new String[cols];
            for (int columnIndex2 = 0; columnIndex2 < cols; ++columnIndex2) {
                cells[rowIndex2][columnIndex2] = String.format("%.2f", this.getElement(rowIndex2, columnIndex2));
            }
        }
        int[] widths = new int[cols];
        for (rowIndex = 0; rowIndex < rows; ++rowIndex) {
            for (columnIndex = 0; columnIndex < cols; ++columnIndex) {
                widths[columnIndex] = Math.max(widths[columnIndex], cells[rowIndex][columnIndex].length());
            }
        }
        for (rowIndex = 0; rowIndex < rows; ++rowIndex) {
            for (columnIndex = 0; columnIndex < cols; ++columnIndex) {
                resultString = resultString.append(String.format("%" + widths[columnIndex] + "s%s", cells[rowIndex][columnIndex], columnIndex == cols - 1 ? "\n" : " "));
            }
        }
        return resultString.toString();
    }
}

