/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.mathematics.matrices;

import de.bioforscher.singa.core.utility.Pair;
import de.bioforscher.singa.mathematics.matrices.LabeledMatrix;
import de.bioforscher.singa.mathematics.matrices.SymmetricMatrix;
import de.bioforscher.singa.mathematics.vectors.RegularVector;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;

public class LabeledSymmetricMatrix<LabelType>
extends SymmetricMatrix
implements LabeledMatrix<LabelType> {
    private static final long serialVersionUID = 2860722869189599846L;
    private final Map<LabelType, Integer> labelMap = new IdentityHashMap<LabelType, Integer>();

    public LabeledSymmetricMatrix(double[][] values) {
        super(values);
    }

    @Override
    public void setRowLabel(LabelType label, int rowIndex) {
        if (rowIndex > this.getRowDimension()) {
            throw new IllegalArgumentException("specified index " + rowIndex + " exceeds dimension " + this.getRowDimension());
        }
        this.labelMap.values().remove(rowIndex);
        this.labelMap.put(label, rowIndex);
    }

    @Override
    public RegularVector getRowByLabel(LabelType label) {
        int index = this.labelMap.entrySet().stream().filter(entry -> entry.getKey().equals(label)).findFirst().map(Map.Entry::getValue).orElseThrow(() -> new IllegalArgumentException("specified label " + label + " is not assigned"));
        return this.getRow(index);
    }

    @Override
    public LabelType getRowLabel(int rowIndex) {
        return (LabelType)this.labelMap.entrySet().stream().filter(entry -> ((Integer)entry.getValue()).equals(rowIndex)).map(Map.Entry::getKey).findFirst().orElseThrow(() -> new IllegalArgumentException("no label exists for index " + rowIndex));
    }

    @Override
    public List<LabelType> getRowLabels() {
        return this.labelMap.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getValue)).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    @Override
    public LabelType getColumnLabel(int columnIndex) {
        return this.getRowLabel(columnIndex);
    }

    @Override
    public List<LabelType> getColumnLabels() {
        return this.getRowLabels();
    }

    @Override
    public void setColumnLabel(LabelType label, int columnIndex) {
        this.setRowLabel(label, columnIndex);
    }

    @Override
    public RegularVector getColumnByLabel(LabelType label) {
        return this.getRowByLabel(label);
    }

    @Override
    public Pair<Integer> getPositionFromLabels(LabelType rowLabel, LabelType columnLabel) {
        return new Pair((Object)this.labelMap.get(rowLabel), (Object)this.labelMap.get(columnLabel));
    }

    @Override
    public double getValueFromPosition(Pair<Integer> position) {
        return this.getElement((Integer)position.getFirst(), (Integer)position.getSecond());
    }

    @Override
    public String getStringRepresentation() {
        StringJoiner rowJoiner = new StringJoiner("\n");
        if (!this.labelMap.isEmpty()) {
            rowJoiner.add("," + this.labelMap.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(Map.Entry::getKey).map(String::valueOf).collect(Collectors.joining(",")));
        }
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.US);
        DecimalFormat df = (DecimalFormat)nf;
        df.applyPattern("0.000000");
        double[][] completeElements = this.getCompleteElements();
        for (int i = 0; i < completeElements.length; ++i) {
            StringJoiner columnJoiner = new StringJoiner(",");
            if (!this.labelMap.isEmpty()) {
                columnJoiner.add(String.valueOf(this.getColumnLabel(i)));
            }
            for (int j = 0; j < completeElements.length; ++j) {
                columnJoiner.add(df.format(completeElements[i][j]));
            }
            rowJoiner.add(columnJoiner.toString());
        }
        return rowJoiner.toString();
    }
}

