/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.mathematics.matrices;

import de.bioforscher.singa.core.utility.Pair;
import de.bioforscher.singa.mathematics.matrices.LabeledMatrix;
import de.bioforscher.singa.mathematics.matrices.RegularMatrix;
import de.bioforscher.singa.mathematics.vectors.RegularVector;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;

public class LabeledRegularMatrix<LabelType>
extends RegularMatrix
implements LabeledMatrix<LabelType> {
    private static final long serialVersionUID = 6232384719610197540L;
    private final Map<LabelType, Integer> rowLabelMap = new IdentityHashMap<LabelType, Integer>();
    private final Map<LabelType, Integer> columnLabelMap = new IdentityHashMap<LabelType, Integer>();

    public LabeledRegularMatrix(double[][] values) {
        super(values);
    }

    @Override
    public void setRowLabel(LabelType label, int rowIndex) {
        if (rowIndex > this.getRowDimension()) {
            throw new IllegalArgumentException("specified index " + rowIndex + " exceeds row dimension " + this.getRowDimension());
        }
        this.rowLabelMap.put(label, rowIndex);
    }

    @Override
    public RegularVector getRowByLabel(LabelType label) {
        int rowIndex = this.rowLabelMap.entrySet().stream().filter(entry -> entry.getKey().equals(label)).findFirst().map(Map.Entry::getValue).orElseThrow(() -> new IllegalArgumentException("specified label " + label + " is not assigned to any row"));
        return this.getRow(rowIndex);
    }

    @Override
    public LabelType getRowLabel(int rowIndex) {
        return (LabelType)this.rowLabelMap.entrySet().stream().filter(entry -> ((Integer)entry.getValue()).equals(rowIndex)).map(Map.Entry::getKey).findFirst().orElseThrow(() -> new IllegalArgumentException("no row label exists for row index " + rowIndex));
    }

    @Override
    public List<LabelType> getRowLabels() {
        return this.rowLabelMap.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getValue)).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    @Override
    public void setColumnLabel(LabelType label, int columnIndex) {
        if (columnIndex > this.getColumnDimension()) {
            throw new IllegalArgumentException("specified index " + columnIndex + " exceeds column dimension " + this.getColumnDimension());
        }
        this.columnLabelMap.put(label, columnIndex);
    }

    @Override
    public RegularVector getColumnByLabel(LabelType label) {
        int columnIndex = this.columnLabelMap.entrySet().stream().filter(entry -> entry.getKey().equals(label)).findFirst().map(Map.Entry::getValue).orElseThrow(() -> new IllegalArgumentException("specified label " + label + " is not assigned to any column"));
        return this.getColumn(columnIndex);
    }

    @Override
    public LabelType getColumnLabel(int columnIndex) {
        return (LabelType)this.columnLabelMap.entrySet().stream().filter(entry -> ((Integer)entry.getValue()).equals(columnIndex)).map(Map.Entry::getKey).findFirst().orElseThrow(() -> new IllegalArgumentException("no column label exists for column index " + columnIndex));
    }

    @Override
    public List<LabelType> getColumnLabels() {
        return this.columnLabelMap.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getValue)).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    @Override
    public Pair<Integer> getPositionFromLabels(LabelType rowLabel, LabelType columnLabel) {
        return new Pair((Object)this.rowLabelMap.get(rowLabel), (Object)this.columnLabelMap.get(columnLabel));
    }

    @Override
    public double getValueFromPosition(Pair<Integer> position) {
        return this.getElement((Integer)position.getFirst(), (Integer)position.getSecond());
    }

    @Override
    public String getStringRepresentation() {
        StringJoiner rowJoiner = new StringJoiner("\n");
        if (!this.columnLabelMap.isEmpty()) {
            rowJoiner.add("," + this.columnLabelMap.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(Map.Entry::getKey).map(String::valueOf).collect(Collectors.joining(",")));
        }
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.US);
        DecimalFormat df = (DecimalFormat)nf;
        df.applyPattern("0.000000");
        double[][] elements = this.getElements();
        for (int i = 0; i < elements.length; ++i) {
            StringJoiner columnJoiner = new StringJoiner(",");
            if (!this.rowLabelMap.isEmpty()) {
                columnJoiner.add(String.valueOf(this.getRowLabel(i)));
            }
            for (int j = 0; j < elements[i].length; ++j) {
                columnJoiner.add(df.format(elements[i][j]));
            }
            rowJoiner.add(columnJoiner.toString());
        }
        return rowJoiner.toString();
    }
}

