/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.mathematics.intervals;

import de.bioforscher.singa.core.utility.Range;
import de.bioforscher.singa.mathematics.concepts.Ring;

public class Interval
extends Range<Double>
implements Ring<Interval> {
    public Interval(Double lowerBound, Double upperBound) {
        super((Comparable)lowerBound, (Comparable)upperBound);
    }

    private static double[] minMax(double first, double second, double third, double fourth) {
        double temp;
        if (first > second) {
            temp = first;
            first = second;
            second = temp;
        }
        if (third > fourth) {
            temp = third;
            third = fourth;
            fourth = temp;
        }
        double min = first < third ? first : third;
        double max = second > fourth ? second : fourth;
        return new double[]{min, max};
    }

    @Override
    public Interval add(Interval summand) {
        double upperBound = (Double)this.getUpperBound() + (Double)summand.getUpperBound();
        double lowerBound = (Double)this.getLowerBound() + (Double)summand.getLowerBound();
        return new Interval(lowerBound, upperBound);
    }

    @Override
    public Interval additivelyInvert() {
        return new Interval(-((Double)this.getLowerBound()).doubleValue(), -((Double)this.getUpperBound()).doubleValue());
    }

    @Override
    public Interval multiply(Interval multiplicand) {
        double[] minMax = Interval.minMax((Double)this.getLowerBound() * (Double)multiplicand.getLowerBound(), (Double)this.getLowerBound() * (Double)multiplicand.getUpperBound(), (Double)this.getUpperBound() * (Double)multiplicand.getLowerBound(), (Double)this.getUpperBound() * (Double)multiplicand.getUpperBound());
        return new Interval(minMax[0], minMax[1]);
    }

    @Override
    public Interval subtract(Interval subtrahend) {
        double upperBound = (Double)this.getUpperBound() - (Double)subtrahend.getUpperBound();
        double lowerBound = (Double)this.getLowerBound() - (Double)subtrahend.getLowerBound();
        return new Interval(lowerBound, upperBound);
    }
}

