/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.mathematics.graphs.trees;

public class RedBlackNode<NodeType extends RedBlackNode<NodeType>> {
    private NodeType root;
    private NodeType next;
    private NodeType previous;
    private NodeType right;
    private NodeType left;
    private NodeType parent;
    private boolean isRed;

    public void insertSuccessor(NodeType node, NodeType successor) {
        RedBlackNode<NodeType> parent;
        if (node != null) {
            ((RedBlackNode)successor).setPrevious(node);
            ((RedBlackNode)successor).setNext(((RedBlackNode)node).getNext());
            if (((RedBlackNode)node).getNext() != null) {
                ((RedBlackNode)((RedBlackNode)node).getNext()).setPrevious(successor);
            }
            ((RedBlackNode)node).setNext(successor);
            if (((RedBlackNode)node).getRight() != null) {
                node = ((RedBlackNode)node).getRight();
                while (((RedBlackNode)node).getLeft() != null) {
                    node = ((RedBlackNode)node).getLeft();
                }
                ((RedBlackNode)node).setLeft(successor);
            } else {
                ((RedBlackNode)node).setRight(successor);
            }
            parent = (RedBlackNode<NodeType>)node;
        } else if (this.root != null) {
            node = this.getFirst(this.root);
            ((RedBlackNode)successor).setPrevious(null);
            ((RedBlackNode)successor).setNext(node);
            ((RedBlackNode)node).setPrevious(successor);
            ((RedBlackNode)node).setLeft(successor);
            parent = (RedBlackNode<NodeType>)node;
        } else {
            ((RedBlackNode)successor).setPrevious(null);
            ((RedBlackNode)successor).setNext(null);
            this.root = successor;
            parent = null;
        }
        ((RedBlackNode)successor).setLeft(null);
        ((RedBlackNode)successor).setRight(null);
        ((RedBlackNode)successor).setParent(parent);
        ((RedBlackNode)successor).setRed(true);
        node = successor;
        while (parent != null && parent.isRed()) {
            NodeType uncle;
            NodeType grandpa = parent.getParent();
            if (parent == ((RedBlackNode)grandpa).getLeft()) {
                uncle = ((RedBlackNode)grandpa).getRight();
                if (uncle != null && ((RedBlackNode)uncle).isRed()) {
                    parent.setRed(false);
                    ((RedBlackNode)uncle).setRed(false);
                    ((RedBlackNode)grandpa).setRed(true);
                    node = grandpa;
                } else {
                    if (node == parent.getRight()) {
                        this.rotateLeft(parent);
                        node = parent;
                        parent = ((RedBlackNode)node).getParent();
                    }
                    parent.setRed(false);
                    ((RedBlackNode)grandpa).setRed(true);
                    this.rotateRight(grandpa);
                }
            } else {
                uncle = ((RedBlackNode)grandpa).getLeft();
                if (uncle != null && ((RedBlackNode)uncle).isRed()) {
                    parent.setRed(false);
                    ((RedBlackNode)uncle).setRed(false);
                    ((RedBlackNode)grandpa).setRed(true);
                    node = grandpa;
                } else {
                    if (node == parent.getLeft()) {
                        this.rotateRight(parent);
                        node = parent;
                        parent = ((RedBlackNode)node).getParent();
                    }
                    parent.setRed(false);
                    ((RedBlackNode)grandpa).setRed(true);
                    this.rotateLeft(grandpa);
                }
            }
            parent = ((RedBlackNode)node).getParent();
        }
        ((RedBlackNode)this.root).setRed(false);
    }

    public void removeNode(NodeType node) {
        boolean isRed;
        if (((RedBlackNode)node).getNext() != null) {
            ((RedBlackNode)((RedBlackNode)node).getNext()).setPrevious(((RedBlackNode)node).getPrevious());
        }
        if (((RedBlackNode)node).getPrevious() != null) {
            ((RedBlackNode)((RedBlackNode)node).getPrevious()).setNext(((RedBlackNode)node).getNext());
        }
        ((RedBlackNode)node).setNext(null);
        ((RedBlackNode)node).setPrevious(null);
        Object parent = ((RedBlackNode)node).getParent();
        NodeType left = ((RedBlackNode)node).getLeft();
        Object right = ((RedBlackNode)node).getRight();
        Object next = left == null ? right : (right == null ? left : this.getFirst(right));
        if (parent != null) {
            if (((RedBlackNode)parent).getLeft() == node) {
                ((RedBlackNode)parent).setLeft(next);
            } else {
                ((RedBlackNode)parent).setRight(next);
            }
        } else {
            this.root = next;
        }
        if (left != null && right != null) {
            isRed = ((RedBlackNode)next).isRed();
            ((RedBlackNode)next).setRed(((RedBlackNode)node).isRed());
            ((RedBlackNode)next).setLeft(left);
            ((RedBlackNode)left).setParent(next);
            if (next != right) {
                parent = ((RedBlackNode)next).getParent();
                ((RedBlackNode)next).setParent(((RedBlackNode)node).getParent());
                node = ((RedBlackNode)next).getRight();
                ((RedBlackNode)parent).setLeft(node);
                ((RedBlackNode)next).setRight(right);
                ((RedBlackNode)right).setParent(next);
            } else {
                ((RedBlackNode)next).setParent(parent);
                parent = next;
                node = ((RedBlackNode)next).getRight();
            }
        } else {
            isRed = ((RedBlackNode)node).isRed();
            node = next;
        }
        if (node != null) {
            ((RedBlackNode)node).setParent(parent);
        }
        if (isRed) {
            return;
        }
        if (node != null && ((RedBlackNode)node).isRed()) {
            ((RedBlackNode)node).setRed(false);
            return;
        }
        while (node != this.root) {
            NodeType sibling;
            if (node == ((RedBlackNode)parent).getLeft()) {
                sibling = ((RedBlackNode)parent).getRight();
                if (((RedBlackNode)sibling).isRed()) {
                    ((RedBlackNode)sibling).setRed(false);
                    ((RedBlackNode)parent).setRed(true);
                    this.rotateLeft(parent);
                    sibling = ((RedBlackNode)parent).getRight();
                }
                if (((RedBlackNode)sibling).getLeft() != null && ((RedBlackNode)((RedBlackNode)sibling).getLeft()).isRed() || ((RedBlackNode)sibling).getRight() != null && ((RedBlackNode)((RedBlackNode)sibling).getRight()).isRed()) {
                    if (((RedBlackNode)sibling).getRight() == null || !((RedBlackNode)((RedBlackNode)sibling).getRight()).isRed()) {
                        ((RedBlackNode)((RedBlackNode)sibling).getLeft()).setRed(false);
                        ((RedBlackNode)sibling).setRed(true);
                        this.rotateRight(sibling);
                        sibling = ((RedBlackNode)parent).getRight();
                    }
                    ((RedBlackNode)sibling).setRed(((RedBlackNode)parent).isRed());
                    ((RedBlackNode)parent).setRed(false);
                    ((RedBlackNode)((RedBlackNode)sibling).getRight()).setRed(false);
                    this.rotateLeft(parent);
                    node = this.root;
                    break;
                }
            } else {
                sibling = ((RedBlackNode)parent).getLeft();
                if (((RedBlackNode)sibling).isRed()) {
                    ((RedBlackNode)sibling).setRed(false);
                    ((RedBlackNode)parent).setRed(true);
                    this.rotateRight(parent);
                    sibling = ((RedBlackNode)parent).getLeft();
                }
                if (((RedBlackNode)sibling).getLeft() != null && ((RedBlackNode)((RedBlackNode)sibling).getLeft()).isRed() || ((RedBlackNode)sibling).getRight() != null && ((RedBlackNode)((RedBlackNode)sibling).getRight()).isRed()) {
                    if (((RedBlackNode)sibling).getLeft() == null || !((RedBlackNode)((RedBlackNode)sibling).getLeft()).isRed()) {
                        ((RedBlackNode)((RedBlackNode)sibling).getRight()).setRed(false);
                        ((RedBlackNode)sibling).setRed(true);
                        this.rotateLeft(sibling);
                        sibling = ((RedBlackNode)parent).getLeft();
                    }
                    ((RedBlackNode)sibling).setRed(((RedBlackNode)parent).isRed());
                    ((RedBlackNode)parent).setRed(false);
                    ((RedBlackNode)((RedBlackNode)sibling).getLeft()).setRed(false);
                    this.rotateRight(parent);
                    node = this.root;
                    break;
                }
            }
            ((RedBlackNode)sibling).setRed(true);
            node = parent;
            parent = ((RedBlackNode)parent).getParent();
            if (!((RedBlackNode)node).isRed()) continue;
        }
        if (node != null) {
            ((RedBlackNode)node).setRed(false);
        }
    }

    private void rotateRight(NodeType node) {
        NodeType q = ((RedBlackNode)node).getLeft();
        NodeType parent = ((RedBlackNode)node).getParent();
        if (parent != null) {
            if (((RedBlackNode)parent).getLeft() == node) {
                ((RedBlackNode)parent).setLeft(q);
            } else {
                ((RedBlackNode)parent).setRight(q);
            }
        } else {
            this.root = q;
        }
        ((RedBlackNode)q).setParent(parent);
        ((RedBlackNode)node).setParent(q);
        ((RedBlackNode)node).setLeft(((RedBlackNode)q).getRight());
        if (((RedBlackNode)node).getLeft() != null) {
            ((RedBlackNode)((RedBlackNode)node).getLeft()).setParent(node);
        }
        ((RedBlackNode)q).setRight(node);
    }

    private void rotateLeft(NodeType node) {
        NodeType p = node;
        NodeType q = ((RedBlackNode)node).getRight();
        NodeType parent = ((RedBlackNode)p).getParent();
        if (parent != null) {
            if (((RedBlackNode)parent).getLeft() == p) {
                ((RedBlackNode)parent).setLeft(q);
            } else {
                ((RedBlackNode)parent).setRight(q);
            }
        } else {
            this.root = q;
        }
        ((RedBlackNode)q).setParent(parent);
        ((RedBlackNode)p).setParent(q);
        ((RedBlackNode)p).setRight(((RedBlackNode)q).getLeft());
        if (((RedBlackNode)p).getRight() != null) {
            ((RedBlackNode)((RedBlackNode)p).getRight()).setParent(p);
        }
        ((RedBlackNode)q).setLeft(p);
    }

    private NodeType getFirst(NodeType node) {
        while (((RedBlackNode)node).getLeft() != null) {
            node = ((RedBlackNode)node).getLeft();
        }
        return node;
    }

    private NodeType getLast(NodeType node) {
        while (((RedBlackNode)node).getRight() != null) {
            node = ((RedBlackNode)node).getRight();
        }
        return node;
    }

    public NodeType getRoot() {
        return this.root;
    }

    public void setRoot(NodeType root) {
        this.root = root;
    }

    public NodeType getNext() {
        return this.next;
    }

    public void setNext(NodeType next) {
        this.next = next;
    }

    public NodeType getPrevious() {
        return this.previous;
    }

    public void setPrevious(NodeType previous) {
        this.previous = previous;
    }

    public NodeType getRight() {
        return this.right;
    }

    public void setRight(NodeType right) {
        this.right = right;
    }

    public NodeType getLeft() {
        return this.left;
    }

    public void setLeft(NodeType left) {
        this.left = left;
    }

    public NodeType getParent() {
        return this.parent;
    }

    public void setParent(NodeType parent) {
        this.parent = parent;
    }

    public boolean isRed() {
        return this.isRed;
    }

    public void setRed(boolean red) {
        this.isRed = red;
    }
}

