/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.mathematics.graphs.model;

import de.bioforscher.singa.mathematics.vectors.Vector2D;

public class GridCoordinateConverter {
    private final int numberOfColumns;
    private final int numberOfRows;

    public GridCoordinateConverter(int numberOfColumns, int numberOfRows) {
        this.numberOfColumns = numberOfColumns;
        this.numberOfRows = numberOfRows;
    }

    public int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    public int getNumberOfRows() {
        return this.numberOfRows;
    }

    public Vector2D convert(int nodeIdentifier) {
        if (nodeIdentifier > this.numberOfColumns * this.numberOfRows) {
            throw new IndexOutOfBoundsException("The node identifier " + nodeIdentifier + " is out of the possible range (" + this.numberOfColumns * this.numberOfRows + ") of a rectangular grid graph with " + this.numberOfRows + " numberOfRows and " + this.numberOfColumns + " numberOfColumns.");
        }
        int y = (int)((double)nodeIdentifier / (double)this.numberOfColumns);
        double x = nodeIdentifier % this.numberOfColumns;
        return new Vector2D(x, (double)y);
    }

    public int convert(Vector2D coordinate) {
        if (coordinate.getX() > (double)this.numberOfColumns) {
            throw new IndexOutOfBoundsException("The x coordinate " + coordinate.getX() + " is out of the possible range " + this.numberOfColumns + ".");
        }
        if (coordinate.getY() > (double)this.numberOfRows) {
            throw new IndexOutOfBoundsException("The x coordinate " + coordinate.getY() + " is out of the possible range " + this.numberOfRows + ".");
        }
        return (int)(coordinate.getY() * (double)this.numberOfColumns + coordinate.getX());
    }
}

