/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.mathematics.graphs.model;

import de.bioforscher.singa.mathematics.algorithms.graphs.DisconnectedSubgraphFinder;
import de.bioforscher.singa.mathematics.geometry.faces.Rectangle;
import de.bioforscher.singa.mathematics.graphs.model.Edge;
import de.bioforscher.singa.mathematics.graphs.model.GenericGraph;
import de.bioforscher.singa.mathematics.graphs.model.GenericNode;
import de.bioforscher.singa.mathematics.graphs.model.Graph;
import de.bioforscher.singa.mathematics.graphs.model.Node;
import de.bioforscher.singa.mathematics.graphs.model.Nodes;
import de.bioforscher.singa.mathematics.graphs.model.RegularNode;
import de.bioforscher.singa.mathematics.graphs.model.UndirectedGraph;
import de.bioforscher.singa.mathematics.graphs.trees.BinaryTree;
import de.bioforscher.singa.mathematics.graphs.trees.BinaryTreeNode;
import de.bioforscher.singa.mathematics.vectors.Vector;
import de.bioforscher.singa.mathematics.vectors.Vector2D;
import de.bioforscher.singa.mathematics.vectors.Vectors;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Graphs {
    private static final Logger logger = LoggerFactory.getLogger(Graphs.class);

    public static UndirectedGraph buildLinearGraph(int numberOfNodes, Rectangle boundingBox) {
        int i;
        UndirectedGraph graph = new UndirectedGraph();
        for (i = 0; i < numberOfNodes; ++i) {
            graph.addNode(Nodes.createRandomlyPlacedNode(i, boundingBox));
        }
        for (i = 0; i < numberOfNodes - 1; ++i) {
            graph.addEdgeBetween(i, (RegularNode)graph.getNode(i), (RegularNode)graph.getNode(i + 1));
        }
        return graph;
    }

    public static UndirectedGraph buildCircularGraph(int numberOfNodes, Rectangle boundingBox) {
        UndirectedGraph graph = Graphs.buildLinearGraph(numberOfNodes, boundingBox);
        graph.addEdgeBetween(numberOfNodes, (RegularNode)graph.getNode(numberOfNodes - 1), (RegularNode)graph.getNode(0));
        return graph;
    }

    public static UndirectedGraph buildTreeGraph(int depth, Rectangle boundingBox) {
        if (depth < 1) {
            throw new IllegalArgumentException("The depth of a tree-like graph must be at least 1");
        }
        UndirectedGraph graph = new UndirectedGraph();
        RegularNode root = Nodes.createRandomlyPlacedNode(0, boundingBox);
        graph.addNode(root);
        Graphs.growTree(depth - 1, graph, root, boundingBox);
        return graph;
    }

    private static void growTree(int depth, UndirectedGraph graph, RegularNode predecessor, Rectangle boundingBox) {
        int next = graph.nextNodeIdentifier();
        graph.addNode(Nodes.createRandomlyPlacedNode(next, boundingBox));
        graph.addEdgeBetween(graph.nextEdgeIdentifier(), predecessor, (RegularNode)graph.getNode(next));
        if (depth > 0) {
            Graphs.growTree(depth - 1, graph, (RegularNode)graph.getNode(next), boundingBox);
            Graphs.growTree(depth - 1, graph, (RegularNode)graph.getNode(next), boundingBox);
        }
    }

    public static UndirectedGraph buildRandomGraph(int numberOfNodes, double edgeProbability, Rectangle boundingBox) {
        UndirectedGraph graph = new UndirectedGraph();
        for (int i = 0; i < numberOfNodes; ++i) {
            graph.addNode(Nodes.createRandomlyPlacedNode(i, boundingBox));
        }
        int j = 0;
        for (RegularNode source : graph.getNodes()) {
            for (RegularNode target : graph.getNodes()) {
                if (source.equals(target) || !(Math.random() < edgeProbability)) continue;
                graph.addEdgeBetween(j, source, target);
                ++j;
            }
        }
        return graph;
    }

    public static UndirectedGraph buildGridGraph(int columns, int rows, Rectangle boundingBox) {
        return Graphs.buildGridGraph(columns, rows, boundingBox, false);
    }

    public static UndirectedGraph buildGridGraph(int columns, int rows, Rectangle boundingBox, boolean periodic) {
        RegularNode target;
        logger.debug("Creating grid graph ...");
        UndirectedGraph graph = new UndirectedGraph();
        double horizontalSpacing = boundingBox.getWidth() / (double)(rows + 1);
        double verticalSpacing = boundingBox.getHeight() / (double)(columns + 1);
        logger.debug("Creating and placing nodes ...");
        int nodeCounter = 0;
        for (int row = 0; row < columns; ++row) {
            for (int column = 0; column < rows; ++column) {
                RegularNode node = new RegularNode(nodeCounter);
                node.setPosition(new Vector2D(horizontalSpacing * (double)(column + 1), verticalSpacing * (double)(row + 1)));
                graph.addNode(node);
                ++nodeCounter;
            }
        }
        Collection nodes = graph.getNodes();
        logger.debug("Adding horizontal connections ...");
        int horizontalCounter = 0;
        for (int row = 0; row < columns; ++row) {
            for (int column = 0; column < rows; ++column) {
                RegularNode source = (RegularNode)graph.getNode(horizontalCounter);
                target = (RegularNode)graph.getNode(horizontalCounter + 1);
                if (horizontalCounter < nodes.size() - 1 && horizontalCounter % rows != rows - 1) {
                    graph.addEdgeBetween(horizontalCounter, source, target);
                }
                ++horizontalCounter;
            }
        }
        logger.debug("Adding vertical connections ...");
        int verticalCounter = 0;
        for (int row = 0; row < columns; ++row) {
            for (int column = 0; column < rows; ++column) {
                RegularNode source = (RegularNode)graph.getNode(verticalCounter);
                RegularNode target2 = (RegularNode)graph.getNode(verticalCounter + rows);
                if (verticalCounter + rows < nodes.size()) {
                    graph.addEdgeBetween(horizontalCounter + verticalCounter + 1, source, target2);
                }
                ++verticalCounter;
            }
        }
        if (periodic) {
            logger.debug("Adding periodic boundary connections");
            for (int c = 0; c < rows; ++c) {
                RegularNode source = (RegularNode)graph.getNode(c);
                target = (RegularNode)graph.getNode(graph.getNodes().size() - (rows - c));
                graph.addEdgeBetween(horizontalCounter + verticalCounter + c + 1, source, target);
            }
            for (int r = 0; r < columns; ++r) {
                RegularNode source = (RegularNode)graph.getNode(r * columns);
                target = (RegularNode)graph.getNode(r * columns + columns - 1);
                graph.addEdgeBetween(horizontalCounter + verticalCounter + rows + r + 1, source, target);
            }
        }
        return graph;
    }

    public static <ContentType> GenericGraph<ContentType> convertTreeToGraph(BinaryTree<ContentType> tree) {
        GenericGraph graph = new GenericGraph();
        BinaryTreeNode<ContentType> root = tree.getRoot();
        GenericNode<ContentType> rootNode = Graphs.convertNode(root, graph);
        graph.addNode(rootNode);
        Graphs.traverseNode(graph, rootNode, root.getLeft());
        Graphs.traverseNode(graph, rootNode, root.getRight());
        return graph;
    }

    private static <ContentType> void traverseNode(GenericGraph<ContentType> graph, GenericNode<ContentType> source, BinaryTreeNode<ContentType> treeNode) {
        GenericNode<ContentType> graphNode = Graphs.convertNode(treeNode, graph);
        graph.addNode(graphNode);
        graph.addEdgeBetween(source, graphNode);
        if (treeNode.getLeft() != null) {
            Graphs.traverseNode(graph, graphNode, treeNode.getLeft());
        }
        if (treeNode.getRight() != null) {
            Graphs.traverseNode(graph, graphNode, treeNode.getRight());
        }
    }

    private static <ContentType> GenericNode<ContentType> convertNode(BinaryTreeNode<ContentType> treeNode, GenericGraph<ContentType> graph) {
        GenericNode<ContentType> result = new GenericNode<ContentType>(graph.nextNodeIdentifier(), treeNode.getData());
        result.setPosition(Vectors.generateRandom2DVector(new Rectangle(200.0, 200.0)));
        return result;
    }

    public static <NodeType extends Node<NodeType, VectorType, IdentifierType>, EdgeType extends Edge<NodeType>, VectorType extends Vector, IdentifierType, GraphType extends Graph<NodeType, EdgeType, IdentifierType>> List<GraphType> findDisconnectedSubgraphs(GraphType graph) {
        return DisconnectedSubgraphFinder.findDisconnectedSubgraphs(graph);
    }
}

