/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.mathematics.graphs.model;

import de.bioforscher.singa.mathematics.graphs.model.Edge;
import de.bioforscher.singa.mathematics.graphs.model.Node;
import de.bioforscher.singa.mathematics.vectors.Vector;
import java.util.Collection;
import java.util.Optional;

public interface Graph<NodeType extends Node<NodeType, ? extends Vector, IdentifierType>, EdgeType extends Edge<NodeType>, IdentifierType> {
    public Collection<NodeType> getNodes();

    public NodeType getNode(IdentifierType var1);

    public IdentifierType addNode(NodeType var1);

    public NodeType removeNode(NodeType var1);

    public NodeType removeNode(IdentifierType var1);

    public Collection<EdgeType> getEdges();

    public EdgeType getEdge(int var1);

    public int addEdgeBetween(int var1, NodeType var2, NodeType var3);

    public int addEdgeBetween(EdgeType var1, NodeType var2, NodeType var3);

    public int addEdgeBetween(NodeType var1, NodeType var2);

    default public Optional<EdgeType> getEdgeBetween(NodeType source, NodeType target) {
        return this.getEdges().stream().filter(edge -> edge.containsNode(source) && edge.containsNode(target)).findAny();
    }

    public boolean containsNode(Object var1);

    public boolean containsEdge(Object var1);

    public IdentifierType nextNodeIdentifier();

    default public int nextEdgeIdentifier() {
        if (this.getEdges().isEmpty()) {
            return 0;
        }
        return this.getEdges().size() + 1;
    }
}

