/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.mathematics.graphs.model;

import de.bioforscher.singa.mathematics.graphs.model.AbstractGraph;
import de.bioforscher.singa.mathematics.graphs.model.GenericEdge;
import de.bioforscher.singa.mathematics.graphs.model.GenericNode;
import de.bioforscher.singa.mathematics.graphs.model.Node;
import de.bioforscher.singa.mathematics.vectors.Vector2D;
import java.util.Collection;
import java.util.Optional;

public class GenericGraph<ContentType>
extends AbstractGraph<GenericNode<ContentType>, GenericEdge<ContentType>, Vector2D, Integer> {
    private int nextNodeIdentifier;

    @Override
    public int addEdgeBetween(int identifier, GenericNode<ContentType> source, GenericNode<ContentType> target) {
        return this.addEdgeBetween(new GenericEdge(identifier), source, target);
    }

    @Override
    public int addEdgeBetween(GenericNode<ContentType> source, GenericNode<ContentType> target) {
        return this.addEdgeBetween(this.nextEdgeIdentifier(), source, target);
    }

    @Override
    public int addEdgeBetween(ContentType sourceContent, ContentType targetContent) {
        Optional<GenericNode<ContentType>> optionalSourceNode = this.getNodeWithContent(sourceContent);
        Optional<GenericNode<ContentType>> optionalTargetNode = this.getNodeWithContent(targetContent);
        if (optionalSourceNode.isPresent()) {
            if (optionalTargetNode.isPresent()) {
                return this.addEdgeBetween((ContentType)optionalSourceNode.get(), (ContentType)optionalTargetNode.get());
            }
            GenericNode<ContentType> targetNode = this.addNode(targetContent);
            return this.addEdgeBetween((ContentType)optionalSourceNode.get(), (ContentType)targetNode);
        }
        if (optionalTargetNode.isPresent()) {
            GenericNode<ContentType> sourceNode = this.addNode(sourceContent);
            return this.addEdgeBetween((ContentType)optionalTargetNode.get(), (ContentType)sourceNode);
        }
        GenericNode<ContentType> targetNode = this.addNode(targetContent);
        GenericNode<ContentType> sourceNode = this.addNode(sourceContent);
        return this.addEdgeBetween((ContentType)targetNode, (ContentType)sourceNode);
    }

    @Override
    public Integer nextNodeIdentifier() {
        return this.nextNodeIdentifier++;
    }

    @Override
    public GenericNode<ContentType> addNode(ContentType content) {
        GenericNode<ContentType> genericNode = new GenericNode<ContentType>(this.nextNodeIdentifier(), content);
        this.addNode(genericNode);
        return genericNode;
    }

    public boolean containsNodeWithContent(ContentType content) {
        for (GenericNode genericNode : this.getNodes()) {
            if (!genericNode.getContent().equals(content)) continue;
            return true;
        }
        return false;
    }

    public Optional<GenericNode<ContentType>> getNodeWithContent(ContentType content) {
        for (GenericNode genericNode : this.getNodes()) {
            if (!genericNode.getContent().equals(content)) continue;
            return Optional.of(genericNode);
        }
        return Optional.empty();
    }

    public GenericGraph<ContentType> getCopy() {
        GenericGraph<ContentType> graphCopy = new GenericGraph<ContentType>();
        Collection nodes = this.getNodes();
        for (GenericNode node : nodes) {
            Node nodeCopy = node.getCopy();
            graphCopy.addNode(nodeCopy);
        }
        Collection edges = this.getEdges();
        for (GenericEdge edge : edges) {
            GenericNode source = (GenericNode)graphCopy.getNode(((GenericNode)edge.getSource()).getIdentifier());
            GenericNode target = (GenericNode)graphCopy.getNode(((GenericNode)edge.getTarget()).getIdentifier());
            graphCopy.addEdgeBetween(edge.getIdentifier(), source, target);
        }
        return graphCopy;
    }
}

