/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.mathematics.graphs.model;

import de.bioforscher.singa.mathematics.graphs.model.Node;
import de.bioforscher.singa.mathematics.vectors.Vector;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractNode<NodeType extends Node<NodeType, VectorType, IdentifierType>, VectorType extends Vector, IdentifierType>
implements Node<NodeType, VectorType, IdentifierType> {
    private IdentifierType identifier;
    private List<NodeType> neighbours;
    private VectorType position;

    public AbstractNode(IdentifierType identifier) {
        this.identifier = identifier;
        this.neighbours = new ArrayList<NodeType>();
    }

    public AbstractNode(IdentifierType identifier, VectorType position) {
        this(identifier);
        this.position = position;
    }

    public AbstractNode(NodeType node) {
        this(node.getIdentifier(), node.getPosition().getCopy());
    }

    @Override
    public IdentifierType getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(IdentifierType identifier) {
        this.identifier = identifier;
    }

    @Override
    public List<NodeType> getNeighbours() {
        return this.neighbours;
    }

    public void setNeighbours(List<NodeType> neighbours) {
        this.neighbours = neighbours;
    }

    @Override
    public void addNeighbour(NodeType node) {
        this.neighbours.add(node);
    }

    public void removeNeighbour(NodeType node) {
        this.neighbours.remove(node);
    }

    public boolean hasNeighbour(NodeType node) {
        return this.neighbours.contains(node);
    }

    @Override
    public VectorType getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(VectorType position) {
        this.position = position;
    }

    @Override
    public int getDegree() {
        return this.neighbours.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractNode that = (AbstractNode)o;
        return this.identifier != null ? this.identifier.equals(that.identifier) : that.identifier == null;
    }

    public int hashCode() {
        return this.identifier != null ? this.identifier.hashCode() : 0;
    }

    public String toString() {
        return "Node " + this.identifier;
    }
}

