/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.mathematics.geometry.faces;

import de.bioforscher.singa.mathematics.geometry.faces.SimplePolygon;
import de.bioforscher.singa.mathematics.geometry.model.HorizontalPosition;
import de.bioforscher.singa.mathematics.geometry.model.VerticalPosition;
import de.bioforscher.singa.mathematics.vectors.Vector2D;

public class Rectangle
extends SimplePolygon {
    private static final int topLeftVertexIndex = 0;
    private static final int bottomRightVertexIndex = 1;

    public Rectangle(Vector2D topLeftVertex, Vector2D bottomRightVertex) {
        super(topLeftVertex, bottomRightVertex);
    }

    public Rectangle(double width, double height) {
        this(new Vector2D(0.0, height), new Vector2D(width, 0.0));
    }

    public Vector2D getTopLeftVertex() {
        return this.getVertex(0);
    }

    public Vector2D getBottomRightVertex() {
        return this.getVertex(1);
    }

    public Vector2D getTopRightVertex() {
        return new Vector2D(this.getTopLeftVertex().getX(), this.getBottomRightVertex().getY());
    }

    public Vector2D getBottomLeftVertex() {
        return new Vector2D(this.getBottomRightVertex().getX(), this.getTopLeftVertex().getY());
    }

    public Vector2D getVertex(HorizontalPosition horizontalPosition, VerticalPosition verticalPosition) {
        if (horizontalPosition == HorizontalPosition.Left) {
            if (verticalPosition == VerticalPosition.Top) {
                return this.getTopLeftVertex();
            }
            return this.getBottomLeftVertex();
        }
        if (verticalPosition == VerticalPosition.Top) {
            return this.getTopRightVertex();
        }
        return this.getBottomRightVertex();
    }

    @Override
    public double getWidth() {
        return this.getTopLeftVertex().distanceTo(this.getTopRightVertex());
    }

    @Override
    public double getHeight() {
        return this.getTopLeftVertex().distanceTo(this.getBottomLeftVertex());
    }

    @Override
    public double getLeftMostXPosition() {
        return this.getTopLeftVertex().getX();
    }

    @Override
    public double getRightMostXPosition() {
        return this.getBottomRightVertex().getX();
    }

    @Override
    public double getTopMostYPosition() {
        return this.getTopLeftVertex().getY();
    }

    @Override
    public double getBottomMostYPosition() {
        return this.getBottomRightVertex().getY();
    }

    @Override
    public double getPerimeter() {
        return 2.0 * (this.getWidth() + this.getHeight());
    }

    @Override
    public double getArea() {
        return this.getWidth() * this.getHeight();
    }
}

