/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.mathematics.geometry.edges;

import de.bioforscher.singa.mathematics.geometry.edges.Line;
import de.bioforscher.singa.mathematics.vectors.Vector2D;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

public class Parabola {
    private final Vector2D focus;
    private final Line directrix;
    private double a = Double.NaN;
    private double b = Double.NaN;
    private double c = Double.NaN;

    public Parabola(Vector2D focus, Line directrix) {
        this.focus = focus;
        this.directrix = directrix;
        this.prepareFormulaForm();
    }

    public Line getDirectrix() {
        return this.directrix;
    }

    public Vector2D getFocus() {
        return this.focus;
    }

    private void prepareFormulaForm() {
        if (Double.isNaN(this.a)) {
            Vector2D vertex = this.getVertex();
            double p = -vertex.distanceTo(this.focus);
            if (!this.isOpenTowardsXAxis()) {
                p *= -1.0;
            }
            this.a = 1.0 / (4.0 * p);
            this.b = -vertex.getX() / (2.0 * p);
            this.c = vertex.getX() * vertex.getX() / (4.0 * p) + vertex.getY();
        }
    }

    public List<Double> getInterceptsWithParabola(Parabola parabola) {
        ArrayList<Double> results = new ArrayList<Double>();
        if (this.focus.getY() == this.directrix.getYIntercept() && parabola.getFocus().getY() == parabola.getDirectrix().getYIntercept()) {
            return results;
        }
        if (this.focus.getY() == this.directrix.getYIntercept()) {
            results.add(this.focus.getX());
            return results;
        }
        if (parabola.getFocus().getY() == parabola.getDirectrix().getYIntercept()) {
            results.add(parabola.focus.getX());
            return results;
        }
        if (this.focus.distanceTo(this.directrix) == parabola.getFocus().distanceTo(parabola.getFocus())) {
            results.add((this.focus.getX() - parabola.getFocus().getX()) / 2.0);
            return results;
        }
        double h2 = parabola.getVertex().getX();
        double k2 = parabola.getVertex().getY();
        double p2 = -parabola.getVertex().distanceTo(parabola.getFocus());
        double a2 = 1.0 / (4.0 * p2);
        double b2 = -h2 / (2.0 * p2);
        double c2 = h2 * h2 / (4.0 * p2) + k2;
        results.add((-(this.b - b2) + Math.sqrt((this.b - b2) * (this.b - b2) - 4.0 * (this.a - a2) * (this.c - c2))) / (2.0 * (this.a - a2)));
        results.add((-(this.b - b2) - Math.sqrt((this.b - b2) * (this.b - b2) - 4.0 * (this.a - a2) * (this.c - c2))) / (2.0 * (this.a - a2)));
        return results;
    }

    public SortedSet<Vector2D> getIntercepts(Line line) {
        TreeSet<Vector2D> intercepts = new TreeSet<Vector2D>(Comparator.comparing(Vector2D::getX));
        if (line.isVertical()) {
            double x = line.getXIntercept();
            intercepts.add(new Vector2D(x, this.getYValue(x)));
        } else {
            double x1 = (-this.b + line.getSlope() + Math.sqrt(4.0 * this.a * line.getYIntercept() + this.b * this.b - 4.0 * this.a * this.c - 2.0 * this.b * line.getSlope() + line.getSlope() * line.getSlope())) / (2.0 * this.a);
            double x2 = (-this.b + line.getSlope() - Math.sqrt(4.0 * this.a * line.getYIntercept() + this.b * this.b - 4.0 * this.a * this.c - 2.0 * this.b * line.getSlope() + line.getSlope() * line.getSlope())) / (2.0 * this.a);
            intercepts.add(new Vector2D(x1, line.getYValue(x1)));
            intercepts.add(new Vector2D(x2, line.getYValue(x2)));
        }
        return intercepts;
    }

    public SortedSet<Double> getXIntercepts() {
        TreeSet<Double> intercepts = new TreeSet<Double>();
        intercepts.add((-this.b - Math.sqrt(this.b * this.b - 4.0 * this.a * this.c)) / (2.0 * this.a));
        intercepts.add((-this.b + Math.sqrt(this.b * this.b - 4.0 * this.a * this.c)) / (2.0 * this.a));
        return intercepts;
    }

    public boolean isOpenTowardsXAxis() {
        return this.focus.getY() < this.directrix.getYIntercept();
    }

    public Vector2D getVertex() {
        return new Vector2D(this.focus.getX(), (this.focus.getY() + this.directrix.getYIntercept()) * 0.5);
    }

    public double getYValue(double x) {
        return this.a * x * x + this.b * x + this.c;
    }

    public String toString() {
        return "Parabola [focus=" + this.focus + ", directrix=" + this.directrix + "]";
    }
}

