/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.mathematics.combinatorics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public class StreamPermutations {
    private static final int UPPER_BOUND = 20;

    private StreamPermutations() {
    }

    private static long factorial(int n) {
        if (n > 20 || n < 0) {
            throw new IllegalArgumentException(n + " is out of range of the upper bound " + 20);
        }
        return LongStream.rangeClosed(2L, n).reduce(1L, (a, b) -> a * b);
    }

    public static <T> List<T> permutation(long no, List<T> items) {
        return StreamPermutations.permutationHelper(no, new LinkedList(Objects.requireNonNull(items)), new ArrayList());
    }

    private static <T> List<T> permutationHelper(long no, LinkedList<T> in, List<T> out) {
        if (in.isEmpty()) {
            return out;
        }
        long subFactorial = StreamPermutations.factorial(in.size() - 1);
        out.add(in.remove((int)(no / subFactorial)));
        return StreamPermutations.permutationHelper((int)(no % subFactorial), in, out);
    }

    @SafeVarargs
    public static <T> Stream<Stream<T>> of(T ... items) {
        List itemList = Arrays.asList(items);
        return LongStream.range(0L, StreamPermutations.factorial(items.length)).mapToObj(no -> StreamPermutations.permutation(no, itemList).stream());
    }
}

