/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.mathematics.algorithms.voronoi.model;

import de.bioforscher.singa.mathematics.algorithms.voronoi.model.SiteEvent;
import de.bioforscher.singa.mathematics.algorithms.voronoi.model.VoronoiEdge;
import de.bioforscher.singa.mathematics.vectors.Vector2D;

public class VoronoiHalfEdge {
    private final SiteEvent site;
    private final VoronoiEdge edge;
    private final double angle;

    VoronoiHalfEdge(VoronoiEdge edge, SiteEvent lSite, SiteEvent rSite) {
        this.site = lSite;
        this.edge = edge;
        if (rSite != null) {
            this.angle = Math.atan2(rSite.getY() - lSite.getY(), rSite.getX() - lSite.getX());
        } else {
            Vector2D startingPoint = edge.getStartingPoint();
            Vector2D endingPoint = edge.getEndingPoint();
            this.angle = edge.getLeftSite().equals(lSite) ? Math.atan2(endingPoint.getX() - startingPoint.getX(), startingPoint.getY() - endingPoint.getY()) : Math.atan2(startingPoint.getX() - endingPoint.getX(), endingPoint.getY() - startingPoint.getY());
        }
    }

    public Vector2D getStartPoint() {
        if (this.edge.getLeftSite().equals(this.site)) {
            return this.edge.getStartingPoint();
        }
        return this.edge.getEndingPoint();
    }

    public Vector2D getEndPoint() {
        if (this.edge.getLeftSite().equals(this.site)) {
            return this.edge.getEndingPoint();
        }
        return this.edge.getStartingPoint();
    }

    public SiteEvent getSite() {
        return this.site;
    }

    public VoronoiEdge getEdge() {
        return this.edge;
    }

    public double getAngle() {
        return this.angle;
    }
}

