/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.mathematics.algorithms.voronoi.model;

import de.bioforscher.singa.mathematics.algorithms.voronoi.model.SiteEvent;
import de.bioforscher.singa.mathematics.vectors.Vector2D;

public class VoronoiEdge {
    private SiteEvent leftSite;
    private SiteEvent rightSite;
    private Vector2D startingPoint;
    private Vector2D endingPoint;

    VoronoiEdge(SiteEvent leftSite, SiteEvent rightSite) {
        this.leftSite = leftSite;
        this.rightSite = rightSite;
    }

    public SiteEvent getLeftSite() {
        return this.leftSite;
    }

    public SiteEvent getRightSite() {
        return this.rightSite;
    }

    public Vector2D getStartingPoint() {
        return this.startingPoint;
    }

    void setStartingPoint(Vector2D startingPoint) {
        this.startingPoint = startingPoint;
    }

    void setStartingPoint(SiteEvent leftSite, SiteEvent rightSite, Vector2D startingPoint) {
        if (this.startingPoint == null && this.endingPoint == null) {
            this.startingPoint = startingPoint;
            this.leftSite = leftSite;
            this.rightSite = rightSite;
        } else if (this.leftSite.equals(rightSite)) {
            this.endingPoint = startingPoint;
        } else {
            this.startingPoint = startingPoint;
        }
    }

    public Vector2D getEndingPoint() {
        return this.endingPoint;
    }

    void setEndingPoint(Vector2D endingPoint) {
        this.endingPoint = endingPoint;
    }

    void setEndingPoint(SiteEvent leftSite, SiteEvent rightSite, Vector2D endingPoint) {
        this.setStartingPoint(rightSite, leftSite, endingPoint);
    }

    public String toString() {
        return "VoronoiEdge{startingPoint=" + this.startingPoint + ", endingPoint=" + this.endingPoint + '}';
    }
}

