/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.mathematics.algorithms.voronoi.model;

import de.bioforscher.singa.mathematics.algorithms.voronoi.model.SiteEvent;
import de.bioforscher.singa.mathematics.algorithms.voronoi.model.VoronoiCell;
import de.bioforscher.singa.mathematics.algorithms.voronoi.model.VoronoiEdge;
import de.bioforscher.singa.mathematics.algorithms.voronoi.model.VoronoiHalfEdge;
import de.bioforscher.singa.mathematics.geometry.faces.Rectangle;
import de.bioforscher.singa.mathematics.vectors.Vector2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VoronoiDiagram {
    private static final Logger logger = LoggerFactory.getLogger(VoronoiDiagram.class);
    private Map<Integer, VoronoiCell> cells = new HashMap<Integer, VoronoiCell>();
    private List<VoronoiEdge> edges = new ArrayList<VoronoiEdge>();
    private List<Vector2D> vertices = new ArrayList<Vector2D>();
    private final Rectangle boundingBox;
    private double leftBorder;
    private double rightBorder;
    private double topBorder;
    private double bottomBorder;

    VoronoiDiagram(Rectangle boundingBox) {
        this.boundingBox = boundingBox;
        this.leftBorder = boundingBox.getLeftMostXPosition();
        this.rightBorder = boundingBox.getRightMostXPosition();
        this.bottomBorder = boundingBox.getTopMostYPosition();
        this.topBorder = boundingBox.getBottomMostYPosition();
    }

    public List<Vector2D> getSites() {
        return this.cells.values().stream().map(cell -> cell.getSite().getSite()).collect(Collectors.toList());
    }

    public List<VoronoiEdge> getEdges() {
        return this.edges;
    }

    VoronoiEdge createEdge(SiteEvent leftSite, SiteEvent rightSite, Vector2D startingPoint, Vector2D endingPoint) {
        VoronoiEdge edge = new VoronoiEdge(leftSite, rightSite);
        this.edges.add(edge);
        if (startingPoint != null) {
            edge.setStartingPoint(leftSite, rightSite, startingPoint);
        }
        if (endingPoint != null) {
            edge.setEndingPoint(leftSite, rightSite, endingPoint);
        }
        this.cells.get(leftSite.getIdentifier()).getHalfEdges().add(new VoronoiHalfEdge(edge, leftSite, rightSite));
        this.cells.get(rightSite.getIdentifier()).getHalfEdges().add(new VoronoiHalfEdge(edge, rightSite, leftSite));
        return edge;
    }

    VoronoiEdge createEdge(SiteEvent leftSite, SiteEvent rightSite) {
        return this.createEdge(leftSite, rightSite, null, null);
    }

    private VoronoiEdge createBorderEdge(SiteEvent leftSite, Vector2D startingPoint, Vector2D endingPoint) {
        VoronoiEdge edge = new VoronoiEdge(leftSite, null);
        edge.setStartingPoint(startingPoint);
        edge.setEndingPoint(endingPoint);
        this.edges.add(edge);
        return edge;
    }

    public List<Vector2D> getVertices() {
        return this.vertices;
    }

    Vector2D createVertex(double x, double y) {
        return this.createVertex(new Vector2D(x, y));
    }

    Vector2D createVertex(Vector2D vertex) {
        if (this.vertices.contains(vertex)) {
            return vertex;
        }
        this.vertices.add(vertex);
        return vertex;
    }

    public VoronoiCell createCell(int siteIdentifier, SiteEvent site) {
        site.setIdentifier(siteIdentifier);
        VoronoiCell cell = new VoronoiCell(site);
        this.cells.put(siteIdentifier, cell);
        return cell;
    }

    public Collection<VoronoiCell> getCells() {
        return this.cells.values();
    }

    public Rectangle getBoundingBox() {
        return this.boundingBox;
    }

    public void clipEdges() {
        for (int iEdge = this.edges.size() - 1; iEdge >= 0; --iEdge) {
            VoronoiEdge edge = this.edges.get(iEdge);
            logger.trace("Post processing edge {}, starting at {}, ending at {}", new Object[]{iEdge, edge.getStartingPoint(), edge.getEndingPoint()});
            if (!this.connectEdge(iEdge, edge) || !this.clipEdge(edge) || Math.abs(edge.getStartingPoint().getX() - edge.getEndingPoint().getX()) < 1.0E-9 && Math.abs(edge.getStartingPoint().getY() - edge.getEndingPoint().getY()) < 1.0E-9) {
                logger.trace(" Removing edge {}, starting at {}, ending at {}", new Object[]{iEdge, edge.getStartingPoint(), edge.getEndingPoint()});
                edge.setStartingPoint(null);
                edge.setEndingPoint(null);
                this.edges.remove(edge);
                continue;
            }
            logger.trace(" Post processed edge: {}, starting at {}, ending at {}", new Object[]{iEdge, edge.getStartingPoint(), edge.getEndingPoint()});
        }
    }

    private boolean connectEdge(int iEdge, VoronoiEdge edge) {
        Vector2D vb = edge.getEndingPoint();
        if (vb != null) {
            return true;
        }
        Vector2D va = edge.getStartingPoint();
        SiteEvent lSite = edge.getLeftSite();
        SiteEvent rSite = edge.getRightSite();
        double lx = lSite.getX();
        double ly = lSite.getY();
        double rx = rSite.getX();
        double ry = rSite.getY();
        double fx = (lx + rx) / 2.0;
        double fy = (ly + ry) / 2.0;
        this.cells.get(lSite.getIdentifier()).setClosed(false);
        this.cells.get(rSite.getIdentifier()).setClosed(false);
        double fm = 0.0;
        double fb = 0.0;
        if (ry != ly) {
            fm = (lx - rx) / (ry - ly);
            fb = fy - fm * fx;
        }
        if (Double.isInfinite(fm)) {
            if (fx < this.leftBorder || fx >= this.rightBorder) {
                return false;
            }
            if (lx > rx) {
                if (va == null || va.getY() < this.topBorder) {
                    va = this.createVertex(fx, this.topBorder);
                } else if (va.getY() >= this.bottomBorder) {
                    return false;
                }
                vb = this.createVertex(fx, this.bottomBorder);
            } else {
                if (va == null || va.getY() > this.bottomBorder) {
                    va = this.createVertex(fx, this.bottomBorder);
                } else if (va.getY() < this.topBorder) {
                    return false;
                }
                vb = this.createVertex(fx, this.topBorder);
            }
        } else if (fm < -1.0 || fm > 1.0) {
            if (lx > rx) {
                if (va == null || va.getY() < this.topBorder) {
                    va = this.createVertex((this.topBorder - fb) / fm, this.topBorder);
                } else if (va.getY() >= this.bottomBorder) {
                    return false;
                }
                vb = this.createVertex((this.bottomBorder - fb) / fm, this.bottomBorder);
            } else {
                if (va == null || va.getY() > this.bottomBorder) {
                    va = this.createVertex((this.bottomBorder - fb) / fm, this.bottomBorder);
                } else if (va.getY() < this.topBorder) {
                    return false;
                }
                vb = this.createVertex((this.topBorder - fb) / fm, this.topBorder);
            }
        } else if (ly < ry) {
            if (va == null || va.getX() < this.leftBorder) {
                va = this.createVertex(this.leftBorder, fm * this.leftBorder + fb);
            } else if (va.getX() >= this.rightBorder) {
                return false;
            }
            vb = this.createVertex(this.rightBorder, fm * this.rightBorder + fb);
        } else {
            if (va == null || va.getX() > this.rightBorder) {
                va = this.createVertex(this.rightBorder, fm * this.rightBorder + fb);
            } else if (va.getX() < this.leftBorder) {
                return false;
            }
            vb = this.createVertex(this.leftBorder, fm * this.leftBorder + fb);
        }
        edge.setStartingPoint(va);
        edge.setEndingPoint(vb);
        logger.trace("Connected edge {} to {} and {}.", new Object[]{iEdge, va, vb});
        return true;
    }

    private boolean clipEdge(VoronoiEdge edge) {
        double ax = edge.getStartingPoint().getX();
        double ay = edge.getStartingPoint().getY();
        double bx = edge.getEndingPoint().getX();
        double by = edge.getEndingPoint().getY();
        double t0 = 0.0;
        double t1 = 1.0;
        double dx = bx - ax;
        double dy = by - ay;
        double q = ax - this.leftBorder;
        if (dx == 0.0 && q < 0.0) {
            return false;
        }
        double r = -q / dx;
        if (dx < 0.0) {
            if (r < t0) {
                return false;
            }
            if (r < t1) {
                t1 = r;
            }
        } else if (dx > 0.0) {
            if (r > t1) {
                return false;
            }
            if (r > t0) {
                t0 = r;
            }
        }
        q = this.rightBorder - ax;
        if (dx == 0.0 && q < 0.0) {
            return false;
        }
        r = q / dx;
        if (dx < 0.0) {
            if (r > t1) {
                return false;
            }
            if (r > t0) {
                t0 = r;
            }
        } else if (dx > 0.0) {
            if (r < t0) {
                return false;
            }
            if (r < t1) {
                t1 = r;
            }
        }
        q = ay - this.topBorder;
        if (dy == 0.0 && q < 0.0) {
            return false;
        }
        r = -q / dy;
        if (dy < 0.0) {
            if (r < t0) {
                return false;
            }
            if (r < t1) {
                t1 = r;
            }
        } else if (dy > 0.0) {
            if (r > t1) {
                return false;
            }
            if (r > t0) {
                t0 = r;
            }
        }
        q = this.bottomBorder - ay;
        if (dy == 0.0 && q < 0.0) {
            return false;
        }
        r = q / dy;
        if (dy < 0.0) {
            if (r > t1) {
                return false;
            }
            if (r > t0) {
                t0 = r;
            }
        } else if (dy > 0.0) {
            if (r < t0) {
                return false;
            }
            if (r < t1) {
                t1 = r;
            }
        }
        if (t0 > 0.0) {
            edge.setStartingPoint(this.createVertex(ax + t0 * dx, ay + t0 * dy));
        }
        if (t1 < 1.0) {
            edge.setEndingPoint(this.createVertex(ax + t1 * dx, ay + t1 * dy));
        }
        if (t0 > 0.0 || t1 < 1.0) {
            this.cells.get(edge.getLeftSite().getIdentifier()).setClosed(false);
            this.cells.get(edge.getRightSite().getIdentifier()).setClosed(false);
        }
        return true;
    }

    public void closeCells() {
        for (VoronoiCell cell : this.cells.values()) {
            if (cell.prepareHalfEdges() == 0 || cell.isClosed()) continue;
            List<VoronoiHalfEdge> halfEdges = cell.getHalfEdges();
            int nHalfedges = halfEdges.size();
            for (int iLeft = 0; iLeft < nHalfedges; ++iLeft) {
                VoronoiEdge edge;
                Vector2D vb;
                boolean lastBorderSegment;
                Vector2D va = halfEdges.get(iLeft).getEndPoint();
                Vector2D vz = halfEdges.get((iLeft + 1) % nHalfedges).getStartPoint();
                if (!(Math.abs(va.getX() - vz.getX()) >= 1.0E-9) && !(Math.abs(va.getY() - vz.getY()) >= 1.0E-9)) continue;
                if (VoronoiDiagram.equalWithEpsilon(va.getX(), this.leftBorder) && VoronoiDiagram.lessThanWithEpsilon(va.getY(), this.bottomBorder)) {
                    lastBorderSegment = VoronoiDiagram.equalWithEpsilon(vz.getX(), this.leftBorder);
                    vb = this.createVertex(this.leftBorder, lastBorderSegment ? vz.getY() : this.bottomBorder);
                    edge = this.createBorderEdge(cell.getSite(), va, vb);
                    halfEdges.add(++iLeft, new VoronoiHalfEdge(edge, cell.getSite(), null));
                    ++nHalfedges;
                    if (lastBorderSegment) break;
                    va = vb;
                }
                if (VoronoiDiagram.equalWithEpsilon(va.getY(), this.bottomBorder) && VoronoiDiagram.lessThanWithEpsilon(va.getX(), this.rightBorder)) {
                    lastBorderSegment = VoronoiDiagram.equalWithEpsilon(vz.getY(), this.bottomBorder);
                    vb = this.createVertex(lastBorderSegment ? vz.getX() : this.rightBorder, this.bottomBorder);
                    edge = this.createBorderEdge(cell.getSite(), va, vb);
                    halfEdges.add(++iLeft, new VoronoiHalfEdge(edge, cell.getSite(), null));
                    ++nHalfedges;
                    if (lastBorderSegment) break;
                    va = vb;
                }
                if (VoronoiDiagram.equalWithEpsilon(va.getX(), this.rightBorder) && VoronoiDiagram.greaterThanWithEpsilon(va.getY(), this.topBorder)) {
                    lastBorderSegment = VoronoiDiagram.equalWithEpsilon(vz.getX(), this.rightBorder);
                    vb = this.createVertex(this.rightBorder, lastBorderSegment ? vz.getY() : this.topBorder);
                    edge = this.createBorderEdge(cell.getSite(), va, vb);
                    halfEdges.add(++iLeft, new VoronoiHalfEdge(edge, cell.getSite(), null));
                    ++nHalfedges;
                    if (lastBorderSegment) break;
                    va = vb;
                }
                if (!VoronoiDiagram.equalWithEpsilon(va.getY(), this.topBorder) || !VoronoiDiagram.greaterThanWithEpsilon(va.getX(), this.leftBorder)) continue;
                lastBorderSegment = VoronoiDiagram.equalWithEpsilon(vz.getY(), this.topBorder);
                vb = this.createVertex(lastBorderSegment ? vz.getX() : this.leftBorder, this.topBorder);
                edge = this.createBorderEdge(cell.getSite(), va, vb);
                halfEdges.add(++iLeft, new VoronoiHalfEdge(edge, cell.getSite(), null));
                ++nHalfedges;
                if (lastBorderSegment) break;
                va = vb;
                lastBorderSegment = VoronoiDiagram.equalWithEpsilon(vz.getX(), this.leftBorder);
                vb = this.createVertex(this.leftBorder, lastBorderSegment ? vz.getY() : this.bottomBorder);
                edge = this.createBorderEdge(cell.getSite(), va, vb);
                halfEdges.add(++iLeft, new VoronoiHalfEdge(edge, cell.getSite(), null));
                ++nHalfedges;
                if (lastBorderSegment) break;
                va = vb;
                lastBorderSegment = VoronoiDiagram.equalWithEpsilon(vz.getY(), this.bottomBorder);
                vb = this.createVertex(lastBorderSegment ? vz.getX() : this.rightBorder, this.bottomBorder);
                edge = this.createBorderEdge(cell.getSite(), va, vb);
                halfEdges.add(++iLeft, new VoronoiHalfEdge(edge, cell.getSite(), null));
                ++nHalfedges;
                if (lastBorderSegment) break;
                va = vb;
                lastBorderSegment = VoronoiDiagram.equalWithEpsilon(vz.getX(), this.rightBorder);
                vb = this.createVertex(this.rightBorder, lastBorderSegment ? vz.getY() : this.topBorder);
                edge = this.createBorderEdge(cell.getSite(), va, vb);
                halfEdges.add(++iLeft, new VoronoiHalfEdge(edge, cell.getSite(), null));
                ++nHalfedges;
                if (lastBorderSegment) break;
                System.out.println("This point should never be reached.");
            }
            cell.setClosed(true);
        }
    }

    private static boolean equalWithEpsilon(double a, double b) {
        return Math.abs(a - b) < 1.0E-9;
    }

    private static boolean greaterThanWithEpsilon(double a, double b) {
        return a - b > 1.0E-9;
    }

    private static boolean lessThanWithEpsilon(double a, double b) {
        return b - a > 1.0E-9;
    }
}

