/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.mathematics.algorithms.voronoi.model;

import de.bioforscher.singa.mathematics.algorithms.voronoi.model.SiteEvent;
import de.bioforscher.singa.mathematics.algorithms.voronoi.model.VoronoiEdge;
import de.bioforscher.singa.mathematics.algorithms.voronoi.model.VoronoiHalfEdge;
import de.bioforscher.singa.mathematics.geometry.faces.Rectangle;
import de.bioforscher.singa.mathematics.geometry.model.Polygon;
import de.bioforscher.singa.mathematics.vectors.Vector2D;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;

public class VoronoiCell
implements Polygon {
    public static int OUTSIDE = -1;
    public static int ON_LINE = 0;
    public static int INSIDE = 1;
    private SiteEvent site;
    private List<VoronoiHalfEdge> halfEdges;
    private boolean closed;

    VoronoiCell(SiteEvent site) {
        this.site = site;
        this.halfEdges = new ArrayList<VoronoiHalfEdge>();
        this.closed = true;
    }

    int prepareHalfEdges() {
        ListIterator<VoronoiHalfEdge> halfEdgeIterator = this.halfEdges.listIterator();
        while (halfEdgeIterator.hasNext()) {
            VoronoiEdge edge = halfEdgeIterator.next().getEdge();
            if (edge.getEndingPoint() != null && edge.getStartingPoint() != null) continue;
            halfEdgeIterator.remove();
        }
        this.halfEdges.sort(Comparator.comparing(VoronoiHalfEdge::getAngle).reversed());
        return this.halfEdges.size();
    }

    public List<Integer> getNeighbourIds() {
        ArrayList<Integer> neighbours = new ArrayList<Integer>();
        for (VoronoiHalfEdge halfEdge : this.halfEdges) {
            VoronoiEdge edge = halfEdge.getEdge();
            if (edge.getLeftSite() != null && edge.getLeftSite().getIdentifier() != this.site.getIdentifier()) {
                neighbours.add(edge.getLeftSite().getIdentifier());
                continue;
            }
            if (edge.getRightSite() == null || edge.getRightSite().getIdentifier() == this.site.getIdentifier()) continue;
            neighbours.add(edge.getRightSite().getIdentifier());
        }
        return neighbours;
    }

    public Rectangle getMinimalBoundingBox() {
        double xMin = Double.MAX_VALUE;
        double yMin = Double.MAX_VALUE;
        double xMax = -1.7976931348623157E308;
        double yMax = -1.7976931348623157E308;
        for (VoronoiHalfEdge halfEdge : this.halfEdges) {
            Vector2D startPoint = halfEdge.getStartPoint();
            double currentX = startPoint.getX();
            double currentY = startPoint.getY();
            if (currentX < xMin) {
                xMin = currentX;
            }
            if (currentY < yMin) {
                yMin = currentY;
            }
            if (currentX > xMax) {
                xMax = currentX;
            }
            if (!(currentY > yMax)) continue;
            yMax = currentY;
        }
        return new Rectangle(new Vector2D(xMin, yMax - yMin), new Vector2D(xMax - xMin, yMin));
    }

    public int evaluatePointPosition(Vector2D point) {
        for (VoronoiHalfEdge halfEdge : this.halfEdges) {
            Vector2D p0 = halfEdge.getStartPoint();
            Vector2D p1 = halfEdge.getEndPoint();
            double r = (point.getY() - p0.getY()) * (p1.getX() - p0.getX()) - (point.getX() - p0.getX()) * (p1.getY() - p0.getY());
            if (r == 0.0) {
                return ON_LINE;
            }
            if (!(r > 0.0)) continue;
            return OUTSIDE;
        }
        return INSIDE;
    }

    public SiteEvent getSite() {
        return this.site;
    }

    public List<VoronoiHalfEdge> getHalfEdges() {
        return this.halfEdges;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isOpen() {
        return !this.closed;
    }

    void setClosed(boolean closed) {
        this.closed = closed;
    }

    public Vector2D getCentroid() {
        double x = 0.0;
        double y = 0.0;
        for (VoronoiHalfEdge halfEdge : this.halfEdges) {
            Vector2D startPoint = halfEdge.getStartPoint();
            Vector2D endPoint = halfEdge.getEndPoint();
            double v = startPoint.getX() * endPoint.getY() - endPoint.getX() * startPoint.getY();
            x += (startPoint.getX() + endPoint.getX()) * v;
            y += (startPoint.getY() + endPoint.getY()) * v;
        }
        double m = this.getArea() * 6.0;
        return new Vector2D(x / m, y / m);
    }

    public double getArea() {
        double area = 0.0;
        for (VoronoiHalfEdge halfEdge : this.halfEdges) {
            Vector2D startPoint = halfEdge.getStartPoint();
            Vector2D endPoint = halfEdge.getEndPoint();
            area += startPoint.getX() * endPoint.getY();
            area -= startPoint.getY() * endPoint.getX();
        }
        return area / 2.0;
    }

    public Vector2D[] getVertices() {
        Vector2D[] vertices = new Vector2D[this.halfEdges.size()];
        for (int index = 0; index < this.halfEdges.size(); ++index) {
            vertices[index] = this.halfEdges.get(index).getStartPoint();
        }
        return vertices;
    }

    @Override
    public Vector2D getVertex(int vertexIdentifier) {
        return this.halfEdges.get(vertexIdentifier).getStartPoint();
    }

    @Override
    public int getNumberOfVertices() {
        return this.halfEdges.size();
    }
}

