/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.mathematics.algorithms.voronoi.model;

import de.bioforscher.singa.mathematics.algorithms.voronoi.model.BeachSection;
import de.bioforscher.singa.mathematics.algorithms.voronoi.model.CircleEvent;
import de.bioforscher.singa.mathematics.algorithms.voronoi.model.SiteEvent;
import de.bioforscher.singa.mathematics.algorithms.voronoi.model.VoronoiDiagram;
import de.bioforscher.singa.mathematics.algorithms.voronoi.model.VoronoiEdge;
import de.bioforscher.singa.mathematics.geometry.faces.Rectangle;
import de.bioforscher.singa.mathematics.vectors.Vector2D;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeachLine {
    private static final Logger logger = LoggerFactory.getLogger(BeachLine.class);
    private static final double epsilon = 1.0E-9;
    private BeachSection beachline;
    private TreeSet<CircleEvent> circleEvents;
    private VoronoiDiagram diagram;

    public BeachLine(Rectangle boundingBox) {
        this.diagram = new VoronoiDiagram(boundingBox);
        this.beachline = new BeachSection();
        this.circleEvents = new TreeSet<CircleEvent>(Comparator.comparingDouble(circle -> circle.getEventCoordinate().getY()));
    }

    public void addBeachSection(SiteEvent site) {
        logger.debug("Adding beach section for site {}.", (Object)site);
        double x = site.getX();
        double directrix = site.getY();
        BeachSection node = (BeachSection)this.beachline.getRoot();
        BeachSection lArc = null;
        BeachSection rArc = null;
        while (node != null) {
            logger.trace("Calculating left break point.");
            double dxl = this.calculateLeftBreakPoint(node, directrix) - x;
            logger.trace("Left break point is {}.", (Object)dxl);
            if (dxl > 1.0E-9) {
                node = (BeachSection)node.getLeft();
                continue;
            }
            logger.trace("Calculating right break point.");
            double dxr = x - this.rightBreakPoint(node, directrix);
            logger.trace("Right break point is {}.", (Object)dxr);
            if (dxr > 1.0E-9) {
                if (node.getRight() == null) {
                    lArc = node;
                    break;
                }
                node = (BeachSection)node.getRight();
                continue;
            }
            if (dxl > -1.0E-9) {
                lArc = (BeachSection)node.getPrevious();
                rArc = node;
                break;
            }
            if (dxr > -1.0E-9) {
                lArc = node;
                rArc = (BeachSection)node.getNext();
                break;
            }
            lArc = node;
            rArc = node;
            break;
        }
        BeachSection newArc = new BeachSection(site);
        this.beachline.insertSuccessor(lArc, newArc);
        if (lArc == null && rArc == null) {
            return;
        }
        if (lArc == rArc) {
            this.detachCircleEvent(lArc);
            rArc = new BeachSection(lArc.getSite());
            this.beachline.insertSuccessor(newArc, rArc);
            VoronoiEdge edge = this.diagram.createEdge(lArc.getSite(), newArc.getSite());
            newArc.setEdge(edge);
            rArc.setEdge(edge);
            this.attachCircleEvent(lArc);
            this.attachCircleEvent(rArc);
            return;
        }
        if (lArc != null && rArc == null) {
            newArc.setEdge(this.diagram.createEdge(lArc.getSite(), newArc.getSite()));
            return;
        }
        if (lArc != null) {
            this.detachCircleEvent(lArc);
            this.detachCircleEvent(rArc);
            SiteEvent lSite = lArc.getSite();
            double ax = lSite.getX();
            double ay = lSite.getY();
            double bx = site.getX() - ax;
            double by = site.getY() - ay;
            SiteEvent rSite = rArc.getSite();
            double cx = rSite.getX() - ax;
            double cy = rSite.getY() - ay;
            double d = 2.0 * (bx * cy - by * cx);
            double hb = bx * bx + by * by;
            double hc = cx * cx + cy * cy;
            Vector2D vertex = this.diagram.createVertex((cy * hb - by * hc) / d + ax, (bx * hc - cx * hb) / d + ay);
            rArc.getEdge().setStartingPoint(lSite, rSite, vertex);
            newArc.setEdge(this.diagram.createEdge(lSite, site, null, vertex));
            rArc.setEdge(this.diagram.createEdge(site, rSite, null, vertex));
            this.attachCircleEvent(lArc);
            this.attachCircleEvent(rArc);
        }
    }

    public void removeBeachSection(BeachSection beachSection) {
        logger.trace("Beach section {} collapsed, removing it.", (Object)beachSection);
        CircleEvent circle = beachSection.getCircleEvent();
        double x = circle.getEventCoordinate().getX();
        double y = circle.getYCenter();
        Vector2D vertex = this.diagram.createVertex(x, y);
        BeachSection previous = (BeachSection)beachSection.getPrevious();
        BeachSection next = (BeachSection)beachSection.getNext();
        LinkedList<BeachSection> disappearingTransitions = new LinkedList<BeachSection>();
        disappearingTransitions.push(beachSection);
        this.detachBeachSection(beachSection);
        BeachSection lArc = previous;
        while (lArc.getCircleEvent() != null && Math.abs(x - lArc.getCircleEvent().getEventCoordinate().getX()) < 1.0E-9 && Math.abs(y - lArc.getCircleEvent().getYCenter()) < 1.0E-9) {
            logger.trace("Found beach section to the left - detaching {}.", (Object)lArc);
            previous = (BeachSection)lArc.getPrevious();
            disappearingTransitions.push(lArc);
            this.detachBeachSection(lArc);
            lArc = previous;
        }
        disappearingTransitions.push(lArc);
        this.detachCircleEvent(lArc);
        BeachSection rArc = next;
        while (rArc.getCircleEvent() != null && Math.abs(x - rArc.getCircleEvent().getEventCoordinate().getX()) < 1.0E-9 && Math.abs(y - rArc.getCircleEvent().getYCenter()) < 1.0E-9) {
            logger.trace("Found beach section to the left - detaching {}.", (Object)rArc);
            next = (BeachSection)rArc.getNext();
            disappearingTransitions.offer(rArc);
            this.detachBeachSection(rArc);
            rArc = next;
        }
        disappearingTransitions.offer(rArc);
        this.detachCircleEvent(rArc);
        int nArcs = disappearingTransitions.size();
        for (int iArc = 1; iArc < nArcs; ++iArc) {
            logger.trace("Removing transition {}", (Object)iArc);
            rArc = (BeachSection)disappearingTransitions.get(iArc);
            lArc = (BeachSection)disappearingTransitions.get(iArc - 1);
            rArc.getEdge().setStartingPoint(lArc.getSite(), rArc.getSite(), vertex);
        }
        lArc = (BeachSection)disappearingTransitions.getFirst();
        rArc = (BeachSection)disappearingTransitions.getLast();
        rArc.setEdge(this.diagram.createEdge(lArc.getSite(), rArc.getSite(), null, vertex));
        this.attachCircleEvent(lArc);
        this.attachCircleEvent(rArc);
    }

    private double calculateLeftBreakPoint(BeachSection beachSection, double directrix) {
        logger.trace("Calculating break point for node " + beachSection + " and directrix " + directrix);
        double rightFocusX = beachSection.getSite().getX();
        double rightFocusY = beachSection.getSite().getY();
        double pby2 = rightFocusY - directrix;
        if (pby2 == 0.0) {
            return rightFocusX;
        }
        BeachSection previousSection = (BeachSection)beachSection.getPrevious();
        if (previousSection == null) {
            logger.trace("No beach section to the left.");
            return Double.NEGATIVE_INFINITY;
        }
        SiteEvent leftSite = previousSection.getSite();
        double lfocx = leftSite.getX();
        double lfocy = leftSite.getY();
        double plby2 = lfocy - directrix;
        if (plby2 == 0.0) {
            return lfocx;
        }
        double hl = lfocx - rightFocusX;
        double aby2 = 1.0 / pby2 - 1.0 / plby2;
        double b = hl / plby2;
        if (aby2 != 0.0) {
            return (-b + Math.sqrt(b * b - 2.0 * aby2 * (hl * hl / (-2.0 * plby2) - lfocy + plby2 / 2.0 + rightFocusY - pby2 / 2.0))) / aby2 + rightFocusX;
        }
        return (rightFocusX + lfocx) / 2.0;
    }

    private double rightBreakPoint(BeachSection beachSection, double directrix) {
        BeachSection rArc = (BeachSection)beachSection.getNext();
        if (rArc != null) {
            return this.calculateLeftBreakPoint(rArc, directrix);
        }
        SiteEvent site = beachSection.getSite();
        double result = site.getY() == directrix ? site.getX() : Double.POSITIVE_INFINITY;
        logger.trace("No beach section to the right.", (Object)result);
        return result;
    }

    private void detachBeachSection(BeachSection beachSection) {
        this.detachCircleEvent(beachSection);
        this.beachline.removeNode(beachSection);
    }

    private void detachCircleEvent(BeachSection beachSection) {
        CircleEvent circleEvent = beachSection.getCircleEvent();
        if (circleEvent != null) {
            this.circleEvents.remove(circleEvent);
            beachSection.setCircleEvent(null);
        }
    }

    private void attachCircleEvent(BeachSection beachSection) {
        BeachSection lArc = (BeachSection)beachSection.getPrevious();
        BeachSection rArc = (BeachSection)beachSection.getNext();
        if (lArc == null || rArc == null) {
            return;
        }
        SiteEvent lSite = lArc.getSite();
        SiteEvent cSite = beachSection.getSite();
        SiteEvent rSite = rArc.getSite();
        if (lSite == rSite) {
            return;
        }
        double bx = cSite.getX();
        double by = cSite.getY();
        double ax = lSite.getX() - bx;
        double ay = lSite.getY() - by;
        double cx = rSite.getX() - bx;
        double cy = rSite.getY() - by;
        double d = 2.0 * (ax * cy - ay * cx);
        if (d >= -2.0E-12) {
            return;
        }
        double ha = ax * ax + ay * ay;
        double hc = cx * cx + cy * cy;
        double x = (cy * ha - ay * hc) / d;
        double y = (ax * hc - cx * ha) / d;
        double ycenter = y + by;
        CircleEvent circleEvent = new CircleEvent();
        circleEvent.setBeachSection(beachSection);
        circleEvent.setSite(cSite);
        circleEvent.setEventCoordinate(new Vector2D(x + bx, ycenter + Math.sqrt(x * x + y * y)));
        circleEvent.setYCenter(ycenter);
        beachSection.setCircleEvent(circleEvent);
        this.circleEvents.add(circleEvent);
    }

    public CircleEvent getFirstCircleEvent() {
        if (this.circleEvents.isEmpty()) {
            return null;
        }
        return this.circleEvents.first();
    }

    public VoronoiDiagram getDiagram() {
        return this.diagram;
    }
}

