/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.mathematics.algorithms.voronoi;

import de.bioforscher.singa.mathematics.algorithms.voronoi.VoronoiGenerator;
import de.bioforscher.singa.mathematics.algorithms.voronoi.model.VoronoiCell;
import de.bioforscher.singa.mathematics.algorithms.voronoi.model.VoronoiDiagram;
import de.bioforscher.singa.mathematics.geometry.faces.Rectangle;
import de.bioforscher.singa.mathematics.graphs.model.Edge;
import de.bioforscher.singa.mathematics.graphs.model.Graph;
import de.bioforscher.singa.mathematics.graphs.model.Node;
import de.bioforscher.singa.mathematics.vectors.Vector;
import de.bioforscher.singa.mathematics.vectors.Vector2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VoronoiRelaxation {
    private VoronoiRelaxation() {
    }

    public static List<Vector2D> relax(VoronoiDiagram diagram) {
        Collection<VoronoiCell> cells = diagram.getCells();
        ArrayList<Vector2D> updatedSites = new ArrayList<Vector2D>();
        for (VoronoiCell cell : cells) {
            Vector2D centroid = cell.getCentroid();
            Vector2D site = cell.getSite().getSite();
            double distance = site.distanceTo(centroid);
            if (distance > 2.0) {
                updatedSites.add(centroid.getMidpointTo(site));
                continue;
            }
            updatedSites.add(centroid);
        }
        return updatedSites;
    }

    public static <NodeType extends Node<NodeType, Vector2D, IdentifierType>, EdgeType extends Edge<NodeType>, IdentifierType, GraphType extends Graph<NodeType, EdgeType, IdentifierType>> GraphType relax(GraphType graph, Rectangle boundingBox) {
        HashMap<Integer, Node> nodeMap = new HashMap<Integer, Node>();
        int identifier = 0;
        for (Node nodeType : graph.getNodes()) {
            nodeMap.put(identifier, nodeType);
            ++identifier;
        }
        VoronoiDiagram diagram = VoronoiGenerator.generateVoronoiDiagram(nodeMap, boundingBox);
        Collection<VoronoiCell> cells = diagram.getCells();
        HashMap<Integer, Vector2D> updatedSites = new HashMap<Integer, Vector2D>();
        for (VoronoiCell voronoiCell : cells) {
            Vector2D centroid = voronoiCell.getCentroid();
            Vector2D site = voronoiCell.getSite().getSite();
            double distance = site.distanceTo(centroid);
            updatedSites.put(voronoiCell.getSite().getIdentifier(), centroid.getMidpointTo(site));
        }
        for (Map.Entry entry : nodeMap.entrySet()) {
            ((Node)entry.getValue()).setPosition((Vector)updatedSites.get(entry.getKey()));
        }
        return graph;
    }
}

