/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.mathematics.algorithms.voronoi;

import de.bioforscher.singa.mathematics.algorithms.voronoi.model.BeachLine;
import de.bioforscher.singa.mathematics.algorithms.voronoi.model.CircleEvent;
import de.bioforscher.singa.mathematics.algorithms.voronoi.model.SiteEvent;
import de.bioforscher.singa.mathematics.algorithms.voronoi.model.VoronoiDiagram;
import de.bioforscher.singa.mathematics.geometry.faces.Rectangle;
import de.bioforscher.singa.mathematics.graphs.model.Node;
import de.bioforscher.singa.mathematics.vectors.Vector2D;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.Map;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VoronoiGenerator {
    private static final Logger logger = LoggerFactory.getLogger(VoronoiGenerator.class);
    private BeachLine beachLine;
    private Deque<SiteEvent> siteEvents;

    public static VoronoiDiagram generateVoronoiDiagram(Collection<Vector2D> sites, Rectangle boundingBox) {
        VoronoiGenerator voronoi = new VoronoiGenerator(sites, boundingBox);
        voronoi.generateDiagram();
        return voronoi.beachLine.getDiagram();
    }

    public static <IdentifierType, NodeType extends Node<NodeType, Vector2D, IdentifierType>> VoronoiDiagram generateVoronoiDiagram(Map<Integer, NodeType> nodeMap, Rectangle boundingBox) {
        VoronoiGenerator voronoi = new VoronoiGenerator(nodeMap, boundingBox);
        voronoi.generateDiagram();
        return voronoi.beachLine.getDiagram();
    }

    private VoronoiGenerator(Collection<Vector2D> sites, Rectangle boundingBox) {
        this.beachLine = new BeachLine(boundingBox);
        TreeSet<Vector2D> sortedCopy = new TreeSet<Vector2D>(Comparator.comparingDouble(Vector2D::getY).reversed());
        sortedCopy.addAll(sites);
        this.siteEvents = new ArrayDeque<SiteEvent>();
        sortedCopy.forEach(vector -> this.siteEvents.push(new SiteEvent((Vector2D)vector)));
        logger.trace("Sorted sites in queue: {}", this.siteEvents);
    }

    private <IdentifierType, NodeType extends Node<NodeType, Vector2D, IdentifierType>> VoronoiGenerator(Map<Integer, NodeType> nodeMap, Rectangle boundingBox) {
        this.beachLine = new BeachLine(boundingBox);
        Comparator<Map.Entry> comparator = Comparator.comparing(nodeType -> ((Vector2D)((Node)nodeType.getValue()).getPosition()).getY());
        TreeSet<Map.Entry> sortedCopy = new TreeSet<Map.Entry>(comparator.reversed());
        sortedCopy.addAll(nodeMap.entrySet());
        this.siteEvents = new ArrayDeque<SiteEvent>();
        sortedCopy.forEach(entry -> this.siteEvents.push(new SiteEvent((Integer)entry.getKey(), (Vector2D)((Node)entry.getValue()).getPosition())));
        logger.trace("Sorted sites in queue: {}", this.siteEvents);
    }

    private void generateDiagram() {
        int siteIdentifier = 0;
        SiteEvent siteEvent = this.siteEvents.pop();
        SiteEvent previousSite = null;
        while (true) {
            CircleEvent circleEvent = this.beachLine.getFirstCircleEvent();
            if (siteEvent != null && (circleEvent == null || this.siteEventIsBeforeCircleEvent(siteEvent, circleEvent))) {
                if (previousSite == null || siteEvent.getX() != previousSite.getX() || siteEvent.getY() != previousSite.getY()) {
                    logger.trace("Processing site event: {}", (Object)siteEvent);
                    if (siteEvent.getIdentifier() == -1) {
                        this.beachLine.getDiagram().createCell(siteIdentifier, siteEvent);
                        ++siteIdentifier;
                    } else {
                        this.beachLine.getDiagram().createCell(siteEvent.getIdentifier(), siteEvent);
                    }
                    this.beachLine.addBeachSection(siteEvent);
                    previousSite = siteEvent;
                }
                if (!this.siteEvents.isEmpty()) {
                    siteEvent = this.siteEvents.pop();
                    continue;
                }
                siteEvent = null;
                continue;
            }
            if (circleEvent == null) break;
            logger.trace("Processing circle event: {}", (Object)circleEvent);
            this.beachLine.removeBeachSection(circleEvent.getBeachSection());
        }
        this.postProcess();
    }

    private void postProcess() {
        this.beachLine.getDiagram().clipEdges();
        this.beachLine.getDiagram().closeCells();
    }

    private boolean siteEventIsBeforeCircleEvent(SiteEvent siteEvent, CircleEvent circleEvent) {
        return siteEvent.getY() < circleEvent.getEventCoordinate().getY() || siteEvent.getY() == circleEvent.getEventCoordinate().getY() && siteEvent.getX() < circleEvent.getEventCoordinate().getX();
    }
}

