/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.mathematics.algorithms.superimposition;

import de.bioforscher.singa.mathematics.matrices.Matrix;
import de.bioforscher.singa.mathematics.vectors.Vector;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;

public interface Superimposition<T> {
    public static final String RMSD_FORMAT_PATTERN = "0.000000";

    public List<T> getReference();

    public double getRmsd();

    default public String getFormattedRmsd() {
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.US);
        DecimalFormat df = (DecimalFormat)nf;
        df.applyPattern(RMSD_FORMAT_PATTERN);
        return df.format(this.getRmsd());
    }

    public Vector getTranslation();

    public Matrix getRotation();

    public List<T> getCandidate();

    public List<T> getMappedCandidate();

    default public List<T> getMappedFullCandidate() {
        return this.getMappedCandidate();
    }

    public List<T> applyTo(List<T> var1);
}

