/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.mathematics.algorithms.optimization;

import de.bioforscher.singa.core.utility.Pair;
import de.bioforscher.singa.mathematics.matrices.LabeledMatrix;
import de.bioforscher.singa.mathematics.matrices.LabeledSymmetricMatrix;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KuhnMunkres<DataType> {
    private static final Logger logger = LoggerFactory.getLogger(KuhnMunkres.class);
    private final LabeledMatrix<DataType> labeledCostMatrix;
    private double[][] costMatrix;
    private int dimension;
    private int cols;
    private int rows;
    private double[] labelByWorker;
    private double[] labelByJob;
    private int[] minSlackWorkerByJob;
    private double[] minSlackValueByJob;
    private boolean[] committedWorkers;
    private int[] parentWorkerByCommittedJob;
    private int[] matchJobByWorker;
    private int[] matchWorkerByJob;
    private List<Pair<DataType>> assignedPairs;

    public KuhnMunkres(LabeledMatrix<DataType> labeledCostMatrix) {
        logger.info("calculating optimal assignment for cost matrix with {} rows and {} columns", (Object)labeledCostMatrix.getRowDimension(), (Object)labeledCostMatrix.getColumnDimension());
        this.labeledCostMatrix = labeledCostMatrix;
        if (this.labeledCostMatrix instanceof LabeledSymmetricMatrix) {
            throw new IllegalArgumentException("cost matrix cannot be symmetric because elements cannot be assigned to themselves");
        }
        this.initialize(this.labeledCostMatrix.getElements());
        this.execute();
    }

    private void execute() {
        this.reduce();
        this.computeInitialSolution();
        this.greedyMatch();
        int w = this.fetchUnmatchedWorker();
        while (w < this.dimension) {
            this.initializePhase(w);
            this.executePhase();
            w = this.fetchUnmatchedWorker();
        }
        int[] result = Arrays.copyOf(this.matchJobByWorker, this.rows);
        for (w = 0; w < result.length; ++w) {
            if (result[w] < this.cols) continue;
            result[w] = -1;
        }
        this.assignPairs(result);
    }

    private void assignPairs(int[] result) {
        this.assignedPairs = new ArrayList<Pair<DataType>>();
        for (int i = 0; i < this.labeledCostMatrix.getRowDimension(); ++i) {
            if (result[i] == -1) {
                logger.info("no assignment made for {}", this.labeledCostMatrix.getRowLabel(i));
                continue;
            }
            this.assignedPairs.add(new Pair(this.labeledCostMatrix.getRowLabel(i), this.labeledCostMatrix.getColumnLabel(result[i])));
        }
    }

    private void executePhase() {
        block0: while (true) {
            int minSlackWorker = -1;
            int minSlackJob = -1;
            double minSlackValue = Double.POSITIVE_INFINITY;
            for (int j = 0; j < this.dimension; ++j) {
                if (this.parentWorkerByCommittedJob[j] != -1 || !(this.minSlackValueByJob[j] < minSlackValue)) continue;
                minSlackValue = this.minSlackValueByJob[j];
                minSlackWorker = this.minSlackWorkerByJob[j];
                minSlackJob = j;
            }
            if (minSlackValue > 0.0) {
                this.updateLabeling(minSlackValue);
            }
            this.parentWorkerByCommittedJob[minSlackJob] = minSlackWorker;
            if (this.matchWorkerByJob[minSlackJob] == -1) {
                int committedJob = minSlackJob;
                int parentWorker = this.parentWorkerByCommittedJob[committedJob];
                while (true) {
                    int temp = this.matchJobByWorker[parentWorker];
                    this.match(parentWorker, committedJob);
                    committedJob = temp;
                    if (committedJob == -1) break;
                    parentWorker = this.parentWorkerByCommittedJob[committedJob];
                }
                return;
            }
            int worker = this.matchWorkerByJob[minSlackJob];
            this.committedWorkers[worker] = true;
            int j = 0;
            while (true) {
                double slack;
                if (j >= this.dimension) continue block0;
                if (this.parentWorkerByCommittedJob[j] == -1 && this.minSlackValueByJob[j] > (slack = this.costMatrix[worker][j] - this.labelByWorker[worker] - this.labelByJob[j])) {
                    this.minSlackValueByJob[j] = slack;
                    this.minSlackWorkerByJob[j] = worker;
                }
                ++j;
            }
            break;
        }
    }

    private void updateLabeling(double slack) {
        for (int w = 0; w < this.dimension; ++w) {
            if (!this.committedWorkers[w]) continue;
            int n = w;
            this.labelByWorker[n] = this.labelByWorker[n] + slack;
        }
        for (int j = 0; j < this.dimension; ++j) {
            if (this.parentWorkerByCommittedJob[j] != -1) {
                int n = j;
                this.labelByJob[n] = this.labelByJob[n] - slack;
                continue;
            }
            int n = j;
            this.minSlackValueByJob[n] = this.minSlackValueByJob[n] - slack;
        }
    }

    private void initializePhase(int w) {
        Arrays.fill(this.committedWorkers, false);
        Arrays.fill(this.parentWorkerByCommittedJob, -1);
        this.committedWorkers[w] = true;
        for (int j = 0; j < this.dimension; ++j) {
            this.minSlackValueByJob[j] = this.costMatrix[w][j] - this.labelByWorker[w] - this.labelByJob[j];
            this.minSlackWorkerByJob[j] = w;
        }
    }

    private int fetchUnmatchedWorker() {
        int w;
        for (w = 0; w < this.dimension && this.matchJobByWorker[w] != -1; ++w) {
        }
        return w;
    }

    private void greedyMatch() {
        for (int w = 0; w < this.dimension; ++w) {
            for (int j = 0; j < this.dimension; ++j) {
                if (this.matchJobByWorker[w] != -1 || this.matchWorkerByJob[j] != -1 || this.costMatrix[w][j] - this.labelByWorker[w] - this.labelByJob[j] != 0.0) continue;
                this.match(w, j);
            }
        }
    }

    private void match(int w, int j) {
        this.matchJobByWorker[w] = j;
        this.matchWorkerByJob[j] = w;
    }

    private void initialize(double[][] costMatrix) {
        this.dimension = Math.max(costMatrix.length, costMatrix[0].length);
        this.rows = costMatrix.length;
        this.cols = costMatrix[0].length;
        this.costMatrix = new double[this.dimension][this.dimension];
        for (int w = 0; w < this.dimension; ++w) {
            if (w < costMatrix.length) {
                if (costMatrix[w].length != this.cols) {
                    throw new IllegalArgumentException("irregular cost matrix");
                }
                for (int j = 0; j < this.cols; ++j) {
                    if (Double.isInfinite(costMatrix[w][j])) {
                        throw new IllegalArgumentException("infinite cost");
                    }
                    if (!Double.isNaN(costMatrix[w][j])) continue;
                    throw new IllegalArgumentException("NaN cost");
                }
                this.costMatrix[w] = Arrays.copyOf(costMatrix[w], this.dimension);
                continue;
            }
            this.costMatrix[w] = new double[this.dimension];
        }
        this.labelByWorker = new double[this.dimension];
        this.labelByJob = new double[this.dimension];
        this.minSlackWorkerByJob = new int[this.dimension];
        this.minSlackValueByJob = new double[this.dimension];
        this.committedWorkers = new boolean[this.dimension];
        this.parentWorkerByCommittedJob = new int[this.dimension];
        this.matchJobByWorker = new int[this.dimension];
        Arrays.fill(this.matchJobByWorker, -1);
        this.matchWorkerByJob = new int[this.dimension];
        Arrays.fill(this.matchWorkerByJob, -1);
    }

    private void reduce() {
        int j;
        int w;
        for (int w2 = 0; w2 < this.dimension; ++w2) {
            int j2;
            double min = Double.POSITIVE_INFINITY;
            for (j2 = 0; j2 < this.dimension; ++j2) {
                if (!(this.costMatrix[w2][j2] < min)) continue;
                min = this.costMatrix[w2][j2];
            }
            j2 = 0;
            while (j2 < this.dimension) {
                double[] dArray = this.costMatrix[w2];
                int n = j2++;
                dArray[n] = dArray[n] - min;
            }
        }
        double[] min = new double[this.dimension];
        for (int j3 = 0; j3 < this.dimension; ++j3) {
            min[j3] = Double.POSITIVE_INFINITY;
        }
        for (w = 0; w < this.dimension; ++w) {
            for (j = 0; j < this.dimension; ++j) {
                if (!(this.costMatrix[w][j] < min[j])) continue;
                min[j] = this.costMatrix[w][j];
            }
        }
        for (w = 0; w < this.dimension; ++w) {
            for (j = 0; j < this.dimension; ++j) {
                double[] dArray = this.costMatrix[w];
                int n = j;
                dArray[n] = dArray[n] - min[j];
            }
        }
    }

    private void computeInitialSolution() {
        for (int j = 0; j < this.dimension; ++j) {
            this.labelByJob[j] = Double.POSITIVE_INFINITY;
        }
        for (int w = 0; w < this.dimension; ++w) {
            for (int j = 0; j < this.dimension; ++j) {
                if (!(this.costMatrix[w][j] < this.labelByJob[j])) continue;
                this.labelByJob[j] = this.costMatrix[w][j];
            }
        }
    }

    public List<Pair<DataType>> getAssignedPairs() {
        return this.assignedPairs;
    }
}

