/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.mathematics.algorithms.matrix;

import de.bioforscher.singa.mathematics.matrices.Matrices;
import de.bioforscher.singa.mathematics.matrices.Matrix;
import de.bioforscher.singa.mathematics.matrices.RegularMatrix;
import de.bioforscher.singa.mathematics.vectors.Vector;
import de.bioforscher.singa.mathematics.vectors.Vectors;
import java.util.List;

public class QRDecomposition {
    private final Matrix originalMatrix;
    private Matrix matrixQ;
    private Matrix matrixR;

    private QRDecomposition(Matrix originalMatrix) {
        this.originalMatrix = originalMatrix;
    }

    public static QRDecomposition calculateQRDecomposition(Matrix originalMatrix) {
        QRDecomposition decomposition = new QRDecomposition(originalMatrix);
        List<Vector> columns = Matrices.divideIntoColumns(originalMatrix);
        List<Vector> orthonormalizedVectors = Vectors.orthonormalizeVectors(columns);
        decomposition.matrixQ = Matrices.assembleMatrixFromColumns(orthonormalizedVectors);
        decomposition.matrixR = QRDecomposition.composeR(columns, orthonormalizedVectors);
        return decomposition;
    }

    private static Matrix composeR(List<Vector> originalColumns, List<Vector> orthonormalizedVectors) {
        double[][] elements = new double[originalColumns.size()][originalColumns.size()];
        for (int column = 0; column < originalColumns.size(); ++column) {
            for (int row = column; row < originalColumns.size(); ++row) {
                elements[column][row] = orthonormalizedVectors.get(column).dotProduct(originalColumns.get(row));
            }
        }
        return new RegularMatrix(elements);
    }

    public Matrix getOriginalMatrix() {
        return this.originalMatrix;
    }

    public Matrix getMatrixQ() {
        return this.matrixQ;
    }

    public Matrix getMatrixR() {
        return this.matrixR;
    }
}

