/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.mathematics.algorithms.matrix;

import de.bioforscher.singa.mathematics.matrices.Matrices;
import de.bioforscher.singa.mathematics.matrices.Matrix;
import de.bioforscher.singa.mathematics.vectors.RegularVector;
import de.bioforscher.singa.mathematics.vectors.Vector;
import java.util.Collections;
import java.util.List;

public class LUDecomposition {
    public static Matrix calculateRowEchelonMatrix(Matrix originalMatrix) {
        List<Vector> matrixRows = Matrices.divideIntoRows(originalMatrix);
        for (int iteration = 0; iteration < Math.min(originalMatrix.getColumnDimension(), originalMatrix.getRowDimension()); ++iteration) {
            if (matrixRows.get(iteration).isZero()) continue;
            int pivotIndex = LUDecomposition.getRowWithAbsoluteMaximalElementAtIndex(matrixRows, iteration, iteration);
            if (matrixRows.get(pivotIndex).getElement(iteration) == 0.0) {
                throw new IllegalStateException("The given matrix is singular - no LU decomposition possible.");
            }
            Collections.swap(matrixRows, iteration, pivotIndex);
            for (int row = iteration + 1; row < originalMatrix.getRowDimension(); ++row) {
                if (matrixRows.get(iteration).getElement(iteration) == 0.0) continue;
                double[] newRowValues = new double[originalMatrix.getColumnDimension()];
                double factor = matrixRows.get(row).getElement(iteration) / matrixRows.get(iteration).getElement(iteration);
                for (int column = iteration + 1; column < originalMatrix.getColumnDimension(); ++column) {
                    newRowValues[column] = matrixRows.get(row).getElement(column) - matrixRows.get(iteration).getElement(column) * factor;
                }
                newRowValues[iteration] = 0.0;
                matrixRows.set(row, new RegularVector(newRowValues));
            }
        }
        return Matrices.assembleMatrixFromRows(matrixRows);
    }

    private static int getRowWithAbsoluteMaximalElementAtIndex(List<Vector> matrixRows, int index, int startIndex) {
        double maximalValue = -1.7976931348623157E308;
        int maximalIndex = 0;
        for (int row = startIndex; row < matrixRows.size(); ++row) {
            double currentValue = Math.abs(matrixRows.get(row).getElement(index));
            if (!(currentValue > maximalValue)) continue;
            maximalValue = currentValue;
            maximalIndex = row;
        }
        return maximalIndex;
    }

    public static int getRank(Matrix matrix) {
        List<Vector> echelonRows = Matrices.divideIntoRows(LUDecomposition.calculateRowEchelonMatrix(matrix));
        int rank = 0;
        for (Vector row : echelonRows) {
            if (row.isZero()) continue;
            ++rank;
        }
        return rank;
    }
}

