/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.mathematics.algorithms.graphs;

import de.bioforscher.singa.mathematics.graphs.model.Edge;
import de.bioforscher.singa.mathematics.graphs.model.Graph;
import de.bioforscher.singa.mathematics.graphs.model.Node;
import de.bioforscher.singa.mathematics.vectors.Vector;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;

public class NeighbourhoodExtractor<NodeType extends Node<NodeType, VectorType, IdentifierType>, EdgeType extends Edge<NodeType>, VectorType extends Vector, IdentifierType, GraphType extends Graph<NodeType, EdgeType, IdentifierType>> {
    private final GraphType graph;
    private final NodeType referenceNode;
    private final Set<NodeType> visitedNodes;
    private final List<NodeType> nodesOfSubgraph;
    private final List<EdgeType> edgesOfSubgraph;
    private Queue<NodeType> currentWave;
    private Queue<NodeType> nextWave;

    public NeighbourhoodExtractor(GraphType graph, NodeType referenceNode) {
        this.referenceNode = referenceNode;
        this.graph = graph;
        this.currentWave = new ArrayDeque<NodeType>();
        this.nextWave = new ArrayDeque<NodeType>();
        this.visitedNodes = new HashSet<NodeType>();
        this.nodesOfSubgraph = new ArrayList<NodeType>();
        this.edgesOfSubgraph = new ArrayList<EdgeType>();
    }

    public static <NodeType extends Node<NodeType, VectorType, IdentifierType>, EdgeType extends Edge<NodeType>, VectorType extends Vector, IdentifierType, GraphType extends Graph<NodeType, EdgeType, IdentifierType>> GraphType extractNeighborhood(GraphType graph, NodeType referenceNode, int depth) {
        NeighbourhoodExtractor<NodeType, EdgeType, VectorType, IdentifierType, GraphType> finder = new NeighbourhoodExtractor<NodeType, EdgeType, VectorType, IdentifierType, GraphType>(graph, referenceNode);
        super.extractNeighborhood(depth, false);
        return super.createSubgraph();
    }

    public static <NodeType extends Node<NodeType, VectorType, IdentifierType>, EdgeType extends Edge<NodeType>, VectorType extends Vector, IdentifierType, GraphType extends Graph<NodeType, EdgeType, IdentifierType>> List<NodeType> extractShell(GraphType graph, NodeType referenceNode, int shell) {
        NeighbourhoodExtractor<NodeType, EdgeType, VectorType, IdentifierType, GraphType> finder = new NeighbourhoodExtractor<NodeType, EdgeType, VectorType, IdentifierType, GraphType>(graph, referenceNode);
        super.extractNeighborhood(shell, true);
        return finder.nodesOfSubgraph;
    }

    private void extractNeighborhood(int shell, boolean onlyShell) {
        if (!onlyShell) {
            this.nodesOfSubgraph.add(this.referenceNode);
        }
        this.currentWave.offer(this.referenceNode);
        while (shell > 0) {
            while (!this.currentWave.isEmpty()) {
                Node currentNode = (Node)this.currentWave.poll();
                this.visitedNodes.add(currentNode);
                for (Node neighbour : currentNode.getNeighbours()) {
                    if (this.visitedNodes.contains(neighbour)) continue;
                    if (!onlyShell) {
                        this.nodesOfSubgraph.add(neighbour);
                        Optional edgeOptional = this.graph.getEdgeBetween((Node)currentNode, (Node)neighbour);
                        edgeOptional.ifPresent(this.edgesOfSubgraph::add);
                        this.addConnectionsToVisitedNodes(neighbour);
                    }
                    this.nextWave.add(neighbour);
                    this.visitedNodes.add(neighbour);
                }
            }
            this.currentWave = this.nextWave;
            if (onlyShell && shell == 1) {
                this.nodesOfSubgraph.addAll(this.nextWave);
            }
            this.nextWave = new ArrayDeque<NodeType>();
            --shell;
        }
    }

    private void addConnectionsToVisitedNodes(NodeType neighbour) {
        for (Node visitedNode : this.visitedNodes) {
            Optional edge = this.graph.getEdgeBetween(neighbour, (Node)visitedNode);
            if (!edge.isPresent()) continue;
            this.edgesOfSubgraph.add(edge.get());
        }
    }

    private GraphType createSubgraph() {
        Graph subgraph;
        try {
            subgraph = (Graph)this.graph.getClass().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Failed to create a new graph.");
        }
        Objects.requireNonNull(subgraph);
        for (Node node : this.nodesOfSubgraph) {
            Object copy = node.getCopy();
            subgraph.addNode(copy);
        }
        List<EdgeType> edges = this.edgesOfSubgraph;
        for (Edge edge : edges) {
            Object source = subgraph.getNode(edge.getSource().getIdentifier());
            Object target = subgraph.getNode(edge.getTarget().getIdentifier());
            subgraph.addEdgeBetween(edge.getIdentifier(), source, target);
        }
        return (GraphType)subgraph;
    }
}

