/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.mathematics.algorithms.graphs;

import de.bioforscher.singa.mathematics.graphs.model.Edge;
import de.bioforscher.singa.mathematics.graphs.model.Graph;
import de.bioforscher.singa.mathematics.graphs.model.Node;
import de.bioforscher.singa.mathematics.vectors.Vector;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;

public class DisconnectedSubgraphFinder<NodeType extends Node<NodeType, VectorType, IdentifierType>, EdgeType extends Edge<NodeType>, VectorType extends Vector, IdentifierType, GraphType extends Graph<NodeType, EdgeType, IdentifierType>> {
    private final Queue<NodeType> queue = new ArrayDeque<NodeType>();
    private final GraphType graph;
    private final Collection<NodeType> unprocessedNodes;
    private final List<List<NodeType>> nodesOfSubgraphs;
    private final List<List<EdgeType>> edgesOfSubgraphs;
    private ArrayList<NodeType> currentNodes;

    private DisconnectedSubgraphFinder(GraphType graph) {
        this.unprocessedNodes = new HashSet(graph.getNodes());
        this.nodesOfSubgraphs = new ArrayList<List<NodeType>>();
        this.edgesOfSubgraphs = new ArrayList<List<EdgeType>>();
        this.graph = graph;
    }

    public static <NodeType extends Node<NodeType, VectorType, IdentifierType>, EdgeType extends Edge<NodeType>, VectorType extends Vector, IdentifierType, GraphType extends Graph<NodeType, EdgeType, IdentifierType>> List<GraphType> findDisconnectedSubgraphs(GraphType graph) {
        Optional<NodeType> nextSubgraphOrigin;
        DisconnectedSubgraphFinder<NodeType, EdgeType, VectorType, IdentifierType, GraphType> finder = new DisconnectedSubgraphFinder<NodeType, EdgeType, VectorType, IdentifierType, GraphType>(graph);
        while ((nextSubgraphOrigin = super.getNextSubgraphOrigin()).isPresent()) {
            super.processSubgraph((Node)nextSubgraphOrigin.get());
        }
        return super.createSubgraphs();
    }

    private Optional<NodeType> getNextSubgraphOrigin() {
        if (!this.unprocessedNodes.isEmpty()) {
            return Optional.of(this.unprocessedNodes.iterator().next());
        }
        return Optional.empty();
    }

    private void processSubgraph(NodeType initialNode) {
        Node currentNode;
        this.currentNodes = new ArrayList();
        ArrayList currentEdges = new ArrayList();
        this.processNode(initialNode);
        while ((currentNode = (Node)this.queue.poll()) != null) {
            for (Node neighbor : currentNode.getNeighbours()) {
                if (this.currentNodes.contains(neighbor)) continue;
                this.processNode(neighbor);
                this.graph.getEdgeBetween((Node)currentNode, (Node)neighbor).ifPresent(currentEdges::add);
            }
        }
        this.nodesOfSubgraphs.add(this.currentNodes);
        this.edgesOfSubgraphs.add(currentEdges);
    }

    private void processNode(NodeType node) {
        this.currentNodes.add(node);
        this.queue.offer(node);
        this.unprocessedNodes.remove(node);
    }

    private List<GraphType> createSubgraphs() {
        ArrayList<Graph> subgraphs = new ArrayList<Graph>();
        for (int i = 0; i < this.nodesOfSubgraphs.size(); ++i) {
            Graph subgraph;
            try {
                subgraph = (Graph)this.graph.getClass().newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException("Failed to create a new graph.");
            }
            Objects.requireNonNull(subgraph);
            List<NodeType> nodes = this.nodesOfSubgraphs.get(i);
            for (Node node : nodes) {
                Object copy = node.getCopy();
                subgraph.addNode(copy);
            }
            List<EdgeType> edges = this.edgesOfSubgraphs.get(i);
            for (Edge edge : edges) {
                Object source = subgraph.getNode(edge.getSource().getIdentifier());
                Object target = subgraph.getNode(edge.getTarget().getIdentifier());
                subgraph.addEdgeBetween(edge.getIdentifier(), source, target);
            }
            subgraphs.add(subgraph);
        }
        return subgraphs;
    }
}

