/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.mathematics.algorithms.geometry;

import de.bioforscher.singa.mathematics.algorithms.geometry.BitPlane;
import de.bioforscher.singa.mathematics.geometry.bodies.Sphere;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OttVolumePrediction {
    private static final Logger logger = LoggerFactory.getLogger(OttVolumePrediction.class);
    private static final int DEFAULT_CUBE_SIDE_LENGTH = 200;
    private List<Sphere> spheres;
    private BitPlane xyBitPlane;
    private List<BitPlane> slices = new ArrayList<BitPlane>();
    private long volume = 0L;
    private double[] xx;
    private double[] yy;
    private double[] zz;
    private double[] rr;
    private int[] scaledX;
    private int[] scaledY;
    private int[] scaledZ;
    private int[] scaledR;
    private double xMin;
    private double yMin;
    private double zMin;
    private double xMax;
    private double yMax;
    private double zMax;
    private int cubesSideLength = 200;
    private int numberOfSpheres;
    private double scale;

    private void initialize() {
        this.xyBitPlane = new BitPlane(this.cubesSideLength, this.cubesSideLength);
        this.numberOfSpheres = this.spheres.size();
        this.xx = new double[this.numberOfSpheres];
        this.yy = new double[this.numberOfSpheres];
        this.zz = new double[this.numberOfSpheres];
        this.rr = new double[this.numberOfSpheres];
        this.scaledX = new int[this.numberOfSpheres];
        this.scaledY = new int[this.numberOfSpheres];
        this.scaledZ = new int[this.numberOfSpheres];
        this.scaledR = new int[this.numberOfSpheres];
        this.initializeBoundaries();
        this.initializeArrays();
    }

    private void initializeArrays() {
        logger.debug("Initializing arrays...");
        for (int i = 0; i < this.spheres.size(); ++i) {
            Sphere sphere = this.spheres.get(i);
            this.xx[i] = sphere.getCenter().getX();
            this.yy[i] = sphere.getCenter().getY();
            this.zz[i] = sphere.getCenter().getZ();
            this.rr[i] = sphere.getRadius();
        }
    }

    private void initializeBoundaries() {
        logger.debug("Initializing system boundaries ...");
        this.xMin = Double.MAX_VALUE;
        this.yMin = Double.MAX_VALUE;
        this.zMin = Double.MAX_VALUE;
        this.xMax = -1.7976931348623157E308;
        this.yMax = -1.7976931348623157E308;
        this.zMax = -1.7976931348623157E308;
        for (Sphere sphere : this.spheres) {
            double cMaxZ;
            double cMaxY;
            double cMaxX;
            double cMinZ;
            double cMinY;
            double cMinX = sphere.getCenter().getX() - sphere.getRadius();
            if (cMinX < this.xMin) {
                this.xMin = cMinX;
            }
            if ((cMinY = sphere.getCenter().getY() - sphere.getRadius()) < this.yMin) {
                this.yMin = cMinY;
            }
            if ((cMinZ = sphere.getCenter().getZ() - sphere.getRadius()) < this.zMin) {
                this.zMin = cMinZ;
            }
            if ((cMaxX = sphere.getCenter().getX() + sphere.getRadius()) > this.xMax) {
                this.xMax = cMaxX;
            }
            if ((cMaxY = sphere.getCenter().getY() + sphere.getRadius()) > this.yMax) {
                this.yMax = cMaxY;
            }
            if (!((cMaxZ = sphere.getCenter().getZ() + sphere.getRadius()) > this.zMax)) continue;
            this.zMax = cMaxZ;
        }
        logger.debug("Minimal Boundaries: x = {}, y = {}, z = {}.", new Object[]{this.xMin, this.yMin, this.zMin});
        logger.debug("Maximal Boundaries: x = {}, y = {}, z = {}.", new Object[]{this.xMax, this.yMax, this.zMax});
    }

    public static double predict(List<Sphere> spheres) {
        OttVolumePrediction abacus = new OttVolumePrediction();
        abacus.spheres = spheres;
        return abacus.calculate();
    }

    public double calculate() {
        logger.info("Using Abacus algorithm to estimate volume of {} spheres in a {} side length cube.", (Object)this.spheres.size(), (Object)this.cubesSideLength);
        this.initialize();
        this.scale();
        this.volume = 0L;
        for (int zSlice = 0; zSlice < this.cubesSideLength; ++zSlice) {
            this.xyBitPlane = new BitPlane(this.cubesSideLength, this.cubesSideLength);
            this.createPlane(zSlice);
            this.trace();
        }
        double scaledVolume = (double)this.volume / (this.scale * this.scale * this.scale);
        logger.info("Predicted volume of {}.", (Object)scaledVolume);
        return scaledVolume;
    }

    private void scale() {
        double scaleMax;
        double scaleMin;
        logger.debug("Scaling system ...");
        double width = Math.abs(this.xMax - this.xMin);
        double height = Math.abs(this.yMax - this.yMin);
        double depth = Math.abs(this.zMax - this.zMin);
        logger.debug("Width (x): {}, Height (y): {}, Depth (z): {}.", new Object[]{width, height, depth});
        if (width > height && width > depth) {
            scaleMin = this.xMin;
            scaleMax = this.xMax;
            this.scale = (double)this.cubesSideLength / width;
        } else if (height > width && height > depth) {
            scaleMin = this.yMin;
            scaleMax = this.yMax;
            this.scale = (double)this.cubesSideLength / height;
        } else {
            scaleMin = this.zMin;
            scaleMax = this.zMax;
            this.scale = (double)this.cubesSideLength / depth;
        }
        logger.info("Using scale between {} and {}, resulting in a final scaling factor of {}.", new Object[]{scaleMin, scaleMax, this.scale});
        for (int i = 0; i < this.numberOfSpheres; ++i) {
            this.scaledX[i] = (int)Math.round((this.xx[i] - this.xMin) * this.scale);
            this.scaledY[i] = (int)Math.round((this.yy[i] - this.yMin) * this.scale);
            this.scaledZ[i] = (int)Math.round((this.zz[i] - this.zMin) * this.scale);
            this.scaledR[i] = (int)Math.round(this.rr[i] * this.scale);
        }
    }

    public void trace() {
        for (int x = 0; x < this.cubesSideLength; ++x) {
            for (int y = 0; y < this.cubesSideLength; ++y) {
                if (!this.xyBitPlane.getBit(x, y)) continue;
                ++this.volume;
            }
        }
    }

    private void createPlane(int zSlice) {
        for (int i = 0; i < this.numberOfSpheres; ++i) {
            int sphereRadius = this.scaledR[i];
            int sliceDistance = zSlice - this.scaledZ[i];
            double squaredCenterDistance = sphereRadius * sphereRadius - sliceDistance * sliceDistance;
            if (!(squaredCenterDistance > 0.0)) continue;
            this.createCircle(i, squaredCenterDistance);
        }
        this.slices.add(this.xyBitPlane);
    }

    private void createCircle(int i, double squaredCenterDistance) {
        double centerDistance = Math.sqrt(squaredCenterDistance);
        for (int x = (int)Math.round((double)this.scaledX[i] - centerDistance); x <= this.scaledX[i]; ++x) {
            double dist = x - this.scaledX[i];
            double d = squaredCenterDistance - dist * dist;
            if (!(d > 0.0)) continue;
            int w = (int)Math.sqrt(d);
            int y1 = this.scaledY[i] + w;
            int y2 = this.scaledY[i] - w;
            int ix1 = this.scaledX[i] + this.scaledX[i] - x;
            for (int iy = y2; iy < y1; ++iy) {
                this.xyBitPlane.setBit(x, iy);
                this.xyBitPlane.setBit(ix1, iy);
            }
        }
    }

    public List<Sphere> getSpheres() {
        return this.spheres;
    }

    public void setSpheres(List<Sphere> spheres) {
        this.spheres = spheres;
    }

    public int getCubesSideLength() {
        return this.cubesSideLength;
    }

    public void setCubesSideLength(int cubesSideLength) {
        this.cubesSideLength = cubesSideLength;
    }

    public List<BitPlane> getSlices() {
        return this.slices;
    }

    public double getScale() {
        return this.scale;
    }

    public double getxMin() {
        return this.xMin;
    }

    public double getyMin() {
        return this.yMin;
    }

    public double getzMin() {
        return this.zMin;
    }
}

