/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.mathematics.algorithms.clustering;

import de.bioforscher.singa.mathematics.matrices.LabeledMatrix;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public interface Clustering<DataType> {
    public List<DataType> getDataPoints();

    public LabeledMatrix<DataType> getDistanceMatrix();

    public Map<DataType, List<DataType>> getClusters();

    default public double getSilhouetteCoefficient() {
        double scGlobal = 0.0;
        for (List<DataType> cluster : this.getClusters().values()) {
            double sc = 0.0;
            if (cluster.size() != 1) {
                for (Object dataPoint : cluster) {
                    double distA = 0.0;
                    for (DataType clusterMember : cluster) {
                        if (dataPoint.equals(clusterMember)) continue;
                        distA += this.getDistanceMatrix().getValueForLabel(dataPoint, clusterMember);
                    }
                    distA /= (double)cluster.size();
                    List otherClusters = this.getClusters().values().stream().filter(c -> !c.contains(dataPoint)).collect(Collectors.toList());
                    double distB = Double.MAX_VALUE;
                    for (List otherCluster : otherClusters) {
                        double distC = 0.0;
                        for (Object clusterMember : otherCluster) {
                            if (dataPoint.equals(clusterMember)) continue;
                            distC += this.getDistanceMatrix().getValueForLabel(dataPoint, clusterMember);
                        }
                        if (!((distC /= (double)otherCluster.size()) < distB)) continue;
                        distB = distC;
                    }
                    double s = distA == distB ? 0.0 : (distB - distA) / Math.max(distA, distB);
                    sc += s;
                }
                sc /= (double)cluster.size();
            }
            scGlobal += sc;
        }
        return scGlobal / (double)this.getClusters().size();
    }
}

