/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.mathematics.vectors;

import de.bioforscher.singa.mathematics.matrices.RegularMatrix;
import de.bioforscher.singa.mathematics.metrics.model.Metric;
import de.bioforscher.singa.mathematics.vectors.Vector;
import de.bioforscher.singa.mathematics.vectors.Vector2D;
import de.bioforscher.singa.mathematics.vectors.Vector3D;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;

public class RegularVector
implements Vector {
    private final double[] elements;
    private final int dimension;

    public RegularVector(double ... elements) {
        this.elements = elements;
        this.dimension = elements.length;
    }

    public RegularVector(int dimension) {
        this.elements = new double[dimension];
        this.dimension = dimension;
    }

    public static <VectorDimension extends Vector> VectorDimension createNewVector(double[] elements, Class<VectorDimension> typeClass) {
        try {
            return (VectorDimension)((Vector)typeClass.getConstructor(double[].class).newInstance(new Object[]{elements}));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public <VectorClass extends Vector> VectorClass as(Class<VectorClass> vectorClass) {
        if (Vector2D.isVector2D(this) && vectorClass.equals(Vector2D.class)) {
            return RegularVector.createNewVector(this.getElements(), vectorClass);
        }
        if (Vector3D.isVector3D(this) && vectorClass.equals(Vector3D.class)) {
            return RegularVector.createNewVector(this.getElements(), vectorClass);
        }
        return null;
    }

    @Override
    public double getElement(int index) {
        return this.elements[index];
    }

    @Override
    public double[] getElements() {
        return this.elements;
    }

    @Override
    public int getDimension() {
        return this.dimension;
    }

    @Override
    public String getDimensionAsString() {
        return String.valueOf(this.dimension);
    }

    @Override
    public boolean hasSameDimensions(Vector vector) {
        return vector.getDimension() == this.dimension;
    }

    @Override
    public Vector add(Vector summand) {
        this.assertThatDimensionsMatch(summand);
        double[] values = new double[this.getDimension()];
        for (int d = 0; d < this.getDimension(); ++d) {
            values[d] = this.getElement(d) + summand.getElement(d);
        }
        return new RegularVector(values);
    }

    @Override
    public Vector subtract(Vector subtrahend) {
        this.assertThatDimensionsMatch(subtrahend);
        double[] values = new double[this.getDimension()];
        for (int d = 0; d < this.getDimension(); ++d) {
            values[d] = this.getElement(d) - subtrahend.getElement(d);
        }
        return new RegularVector(values);
    }

    @Override
    public Vector additivelyInvert() {
        double[] values = new double[this.getDimension()];
        for (int d = 0; d < this.getDimension(); ++d) {
            values[d] = -this.getElement(d);
        }
        return new RegularVector(values);
    }

    @Override
    public Vector additiveleyInvertElement(int index) {
        double[] values = new double[this.getDimension()];
        System.arraycopy(this.elements, 0, values, 0, this.getDimension());
        values[index] = -values[index];
        return new RegularVector(values);
    }

    @Override
    public Vector multiply(Vector multiplicand) {
        this.assertThatDimensionsMatch(multiplicand);
        double[] values = new double[this.getDimension()];
        for (int dimension = 0; dimension < this.getDimension(); ++dimension) {
            values[dimension] = this.getElement(dimension) * multiplicand.getElement(dimension);
        }
        return new RegularVector(values);
    }

    @Override
    public Vector multiply(double scalar) {
        double[] values = new double[this.getDimension()];
        for (int dimension = 0; dimension < this.getDimension(); ++dimension) {
            values[dimension] = this.getElement(dimension) * scalar;
        }
        return new RegularVector(values);
    }

    @Override
    public Vector divide(Vector divisor) {
        this.assertThatDimensionsMatch(divisor);
        double[] values = new double[this.getDimension()];
        for (int dimension = 0; dimension < this.getDimension(); ++dimension) {
            values[dimension] = this.getElement(dimension) / divisor.getElement(dimension);
        }
        return new RegularVector(values);
    }

    @Override
    public Vector divide(double scalar) {
        double[] values = new double[this.getDimension()];
        for (int dimension = 0; dimension < this.getDimension(); ++dimension) {
            values[dimension] = this.getElement(dimension) / scalar;
        }
        return new RegularVector(values);
    }

    @Override
    public Vector normalize() {
        return this.multiply(1.0 / this.getMagnitude());
    }

    @Override
    public double dotProduct(Vector vector) {
        this.assertThatDimensionsMatch(vector);
        double product = 0.0;
        for (int dimension = 0; dimension < this.getDimension(); ++dimension) {
            product += this.getElement(dimension) * vector.getElement(dimension);
        }
        return product;
    }

    @Override
    public RegularMatrix dyadicProduct(Vector vector) {
        this.assertThatDimensionsMatch(vector);
        double[][] values = new double[this.getDimension()][vector.getDimension()];
        for (int thisDimension = 0; thisDimension < this.getDimension(); ++thisDimension) {
            for (int otherDimension = 0; otherDimension < vector.getDimension(); ++otherDimension) {
                values[thisDimension][otherDimension] = this.getElement(thisDimension) * vector.getElement(otherDimension);
            }
        }
        return new RegularMatrix(values);
    }

    @Override
    public double getMagnitude() {
        double sum = 0.0;
        for (int dimension = 0; dimension < this.getDimension(); ++dimension) {
            sum += this.getElement(dimension) * this.getElement(dimension);
        }
        return Math.sqrt(sum);
    }

    @Override
    public double distanceTo(Vector vector, Metric<Vector> metric) {
        return metric.calculateDistance(this, vector);
    }

    public String toString() {
        return "Vector " + this.getDimension() + "D " + Arrays.toString(this.elements).replace("[", "(").replace("]", ")");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegularVector that = (RegularVector)o;
        if (this.dimension != that.dimension) {
            return false;
        }
        return Arrays.equals(this.elements, that.elements);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.elements);
        result = 31 * result + this.dimension;
        return result;
    }
}

