/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.mathematics.topology.grids;

import de.bioforscher.singa.mathematics.topology.grids.Cell;
import de.bioforscher.singa.mathematics.topology.grids.CellState;
import de.bioforscher.singa.mathematics.topology.grids.HexagonCoordianteDirection;
import de.bioforscher.singa.mathematics.topology.grids.HexagonCoordinate;
import java.util.HashMap;
import java.util.Map;

public class HexagonGrid
extends HashMap<HexagonCoordinate, Cell> {
    private static final long serialVersionUID = 1L;

    public HexagonGrid() {
    }

    public HexagonGrid(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public HexagonGrid(int initialCapacity) {
        super(initialCapacity);
    }

    public HexagonGrid(Map<? extends HexagonCoordinate, ? extends Cell> m) {
        super(m);
    }

    public HexagonCoordinate getNeighborHexagon(HexagonCoordinate coordinate, HexagonCoordianteDirection direction) {
        return this.getNeighborHexagon(coordinate, direction, 1);
    }

    public HexagonCoordinate getNeighborHexagon(HexagonCoordinate coordinate, HexagonCoordianteDirection direction, int scale) {
        short q = coordinate.getQ();
        short r = coordinate.getR();
        HexagonCoordinate[] result = new HexagonCoordinate[]{new HexagonCoordinate(q + scale, (int)r), new HexagonCoordinate(q + scale, r - scale), new HexagonCoordinate((int)q, r - scale), new HexagonCoordinate(q - scale, (int)r), new HexagonCoordinate(q - scale, r + scale), new HexagonCoordinate((int)q, r + scale)};
        return result[direction.getValue()];
    }

    public Cell getNeighborCell(HexagonCoordinate hexagon, HexagonCoordianteDirection direction) {
        short q = hexagon.getQ();
        short r = hexagon.getR();
        Cell[] result = new Cell[]{this.get(q + 1, (int)r), this.get(q + 1, r - 1), this.get((int)q, r - 1), this.get(q - 1, (int)r), this.get(q - 1, r + 1), this.get((int)q, r + 1)};
        return result[direction.getValue()];
    }

    public Cell[] getNeighborCells(HexagonCoordinate hexagon) {
        short q = hexagon.getQ();
        short r = hexagon.getR();
        return new Cell[]{this.get(q + 1, (int)r), this.get(q + 1, r - 1), this.get((int)q, r - 1), this.get(q - 1, (int)r), this.get(q - 1, r + 1), this.get((int)q, r + 1)};
    }

    public Cell[] getNeighborCells(Cell cell) {
        short q = cell.getQ();
        short r = cell.getR();
        return new Cell[]{this.get(q + 1, (int)r), this.get(q + 1, r - 1), this.get((int)q, r - 1), this.get(q - 1, (int)r), this.get(q - 1, r + 1), this.get((int)q, r + 1)};
    }

    public Cell[] getNeighborCells(short q, short r) {
        return new Cell[]{this.get(q + 1, (int)r), this.get(q + 1, r - 1), this.get((int)q, r - 1), this.get(q - 1, (int)r), this.get(q - 1, r + 1), this.get((int)q, r + 1)};
    }

    public Cell[] getNeighborCells(int q, int r) {
        return new Cell[]{this.get(q + 1, r), this.get(q + 1, r - 1), this.get(q, r - 1), this.get(q - 1, r), this.get(q - 1, r + 1), this.get(q, r + 1)};
    }

    public Cell get(short q, short r) {
        return (Cell)this.get(new HexagonCoordinate(q, r));
    }

    public Cell get(int q, int r) {
        return (Cell)this.get(new HexagonCoordinate(q, r));
    }

    public int getMinQValue() {
        short s;
        int n = Integer.MAX_VALUE;
        for (HexagonCoordinate hexagon : this.keySet()) {
            if (s <= hexagon.getQ()) continue;
            s = hexagon.getQ();
        }
        return s;
    }

    public int getMaxQValue() {
        short s;
        int n = Integer.MIN_VALUE;
        for (HexagonCoordinate hexagon : this.keySet()) {
            if (s >= hexagon.getQ()) continue;
            s = hexagon.getQ();
        }
        return s;
    }

    public int getMinRValue() {
        short s;
        int n = Integer.MAX_VALUE;
        for (HexagonCoordinate hexagon : this.keySet()) {
            if (s <= hexagon.getR()) continue;
            s = hexagon.getR();
        }
        return s;
    }

    public int getMaxRValue() {
        short s;
        int n = Integer.MIN_VALUE;
        for (HexagonCoordinate hexagon : this.keySet()) {
            if (s >= hexagon.getR()) continue;
            s = hexagon.getR();
        }
        return s;
    }

    public HexagonCoordinate getLeftMostHexagon() {
        double minX = Double.MAX_VALUE;
        short minQ = 0;
        short minR = 0;
        for (HexagonCoordinate hexagon : this.keySet()) {
            double currentX = (double)hexagon.getQ() + (double)hexagon.getR() * 0.5;
            if (!(currentX < minX)) continue;
            minX = currentX;
            minQ = hexagon.getQ();
            minR = hexagon.getR();
        }
        return new HexagonCoordinate(minQ, minR);
    }

    public HexagonCoordinate getRightMostHexagon() {
        double maxX = -1.7976931348623157E308;
        short maxQ = 0;
        short maxR = 0;
        for (HexagonCoordinate hexagon : this.keySet()) {
            double currentX = (double)hexagon.getQ() + (double)hexagon.getR() * 0.5;
            if (!(currentX > maxX)) continue;
            maxX = currentX;
            maxQ = hexagon.getQ();
            maxR = hexagon.getR();
        }
        return new HexagonCoordinate(maxQ, maxR);
    }

    public void fillParallelogram(int qMin, int qMax, int rMin, int rMax) {
        for (int q = qMin; q <= qMax; ++q) {
            for (int r = rMin; r <= rMax; ++r) {
                this.put(new HexagonCoordinate(q, r), new Cell(q, r));
            }
        }
    }

    public void fillCircle(HexagonCoordinate centerHex, int radius) {
        this.put(centerHex, new Cell(centerHex.getQ(), centerHex.getR()));
        HexagonCoordinate h = centerHex;
        for (int r = 1; r <= radius; ++r) {
            h = this.getNeighborHexagon(centerHex, HexagonCoordianteDirection.SouthWest, r);
            for (HexagonCoordianteDirection direction : HexagonCoordianteDirection.values()) {
                for (int k = 0; k < r; ++k) {
                    h = this.getNeighborHexagon(h, direction);
                    this.put(h, new Cell(h.getQ(), h.getR()));
                }
            }
        }
    }

    public void fillRectangle(int startQ, int startR, int width, int height) {
        for (int q = startQ; q < startQ + height; ++q) {
            for (int r = startR; r < startR + width; ++r) {
                if (r % 2 == 0) {
                    this.put(new HexagonCoordinate(q - r / 2, r), new Cell(q - r / 2, r));
                    continue;
                }
                this.put(new HexagonCoordinate(q - r / 2, r), new Cell(q - r / 2, r));
            }
        }
    }

    public void setStateOfAllCellsWithRValue(int r, CellState state) {
        this.keySet().stream().filter(hexagon -> hexagon.getR() == r).forEach((? super T hexagon) -> ((Cell)this.get(hexagon)).setState(state));
    }

    public void setStateOfAllCellsWithQValue(int q, CellState state) {
        this.keySet().stream().filter(hexagon -> hexagon.getQ() == q).forEach((? super T hexagon) -> ((Cell)this.get(hexagon)).setState(state));
    }

    public static HexagonGrid fillRadom() {
        HexagonGrid grid = new HexagonGrid(400);
        for (int i = -5; i <= 5; ++i) {
            for (int j = -5; j <= 5; ++j) {
                if (!(Math.random() < 0.6)) continue;
                if (Math.random() < 0.6) {
                    grid.put(new HexagonCoordinate(i, j), new Cell(i, j, CellState.Alive));
                    continue;
                }
                grid.put(new HexagonCoordinate(i, j), new Cell(i, j, CellState.Dead));
            }
        }
        return grid;
    }
}

