/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.mathematics.metrics.model;

import de.bioforscher.singa.mathematics.metrics.implementations.AngularDistance;
import de.bioforscher.singa.mathematics.metrics.implementations.CosineSimilarity;
import de.bioforscher.singa.mathematics.metrics.implementations.MinkowskiMetric;
import de.bioforscher.singa.mathematics.metrics.implementations.SquaredEuclideanDistance;
import de.bioforscher.singa.mathematics.metrics.model.Metric;
import de.bioforscher.singa.mathematics.vectors.Vector;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class VectorMetricProvider {
    private static final VectorMetricProvider INSTANCE = new VectorMetricProvider();
    private final Set<Metric<Vector>> metrics = new HashSet<Metric<Vector>>();
    public static final MinkowskiMetric<Vector> MANHATTAN_METRIC = VectorMetricProvider.addElement(new MinkowskiMetric(1.0));
    public static final MinkowskiMetric<Vector> EUCLIDEAN_METRIC = VectorMetricProvider.addElement(new MinkowskiMetric(2.0));
    public static final SquaredEuclideanDistance<Vector> SQUARED_EUCLIDEAN_METRIC = VectorMetricProvider.addElement(new SquaredEuclideanDistance());
    public static final MinkowskiMetric<Vector> CHEBYCHEV_METRIC = VectorMetricProvider.addElement(new MinkowskiMetric(Double.POSITIVE_INFINITY));
    public static final CosineSimilarity<Vector> COSINE_SIMILARITY = VectorMetricProvider.addElement(new CosineSimilarity());
    public static final AngularDistance<Vector> ANGULAR_DISTANCE = VectorMetricProvider.addElement(new AngularDistance());

    private VectorMetricProvider() {
    }

    public Set<Metric<Vector>> getElements() {
        return Collections.unmodifiableSet(this.metrics);
    }

    private static <MetricType extends Metric<Vector>> MetricType addElement(MetricType element) {
        VectorMetricProvider.INSTANCE.metrics.add(element);
        return element;
    }
}

