/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.mathematics.matrices;

import de.bioforscher.singa.mathematics.matrices.Matrix;
import de.bioforscher.singa.mathematics.matrices.RegularMatrix;
import de.bioforscher.singa.mathematics.vectors.RegularVector;
import de.bioforscher.singa.mathematics.vectors.Vector;

public class SquareMatrix
extends RegularMatrix {
    private static final long serialVersionUID = -8834271370988935890L;

    public SquareMatrix(double[][] values) {
        super(values);
        if (this.getColumnDimension() != this.getRowDimension()) {
            throw new IllegalArgumentException("The SquareMatrix class is designed to handle matrices, where the coulumn dimension is the same as the row dimension. The given array contains " + this.getRowDimension() + " rows and " + this.getColumnDimension() + " columns.");
        }
    }

    protected SquareMatrix(double[][] values, boolean isSymmetric) {
        super(values, isSymmetric);
    }

    SquareMatrix(double[][] values, int rowDimension, int columnDimension) {
        super(values, rowDimension, columnDimension);
    }

    public static boolean isSquare(double[][] potentialValues) {
        int requiredLength = potentialValues.length;
        for (double[] value : potentialValues) {
            if (value.length == requiredLength) continue;
            return false;
        }
        return true;
    }

    public static boolean isSquare(Matrix matrix) {
        return matrix.getColumnDimension() == matrix.getRowDimension();
    }

    public Vector getMainDiagonal() {
        double[] values = new double[this.getRowDimension()];
        for (int diagonalIndex = 0; diagonalIndex < this.getRowDimension(); ++diagonalIndex) {
            values[diagonalIndex] = this.getElement(diagonalIndex, diagonalIndex);
        }
        return new RegularVector(values);
    }

    public double trace() {
        double sum = 0.0;
        for (int diagonalIndex = 0; diagonalIndex < this.getRowDimension(); ++diagonalIndex) {
            sum += this.getElement(diagonalIndex, diagonalIndex);
        }
        return sum;
    }

    public double determinant() {
        return SquareMatrix.determinant(this.getElements(), this.getColumnDimension());
    }

    private static double determinant(double[][] matrix, int order) {
        double determinant = 0.0;
        int sign = 1;
        int p = 0;
        int q = 0;
        if (order == 1) {
            return matrix[0][0];
        }
        double[][] reducedMatrix = new double[order - 1][order - 1];
        for (int x = 0; x < order; ++x) {
            p = 0;
            q = 0;
            for (int i = 1; i < order; ++i) {
                for (int j = 0; j < order; ++j) {
                    if (j == x) continue;
                    reducedMatrix[p][q++] = matrix[i][j];
                    if (q % (order - 1) != 0) continue;
                    ++p;
                    q = 0;
                }
            }
            determinant += matrix[0][x] * SquareMatrix.determinant(reducedMatrix, order - 1) * (double)sign;
            sign = -sign;
        }
        return determinant;
    }
}

