/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.mathematics.matrices;

import de.bioforscher.singa.core.utility.Pair;
import de.bioforscher.singa.mathematics.concepts.MultiDimensional;
import de.bioforscher.singa.mathematics.concepts.Ring;
import de.bioforscher.singa.mathematics.exceptions.IncompatibleDimensionsException;
import de.bioforscher.singa.mathematics.vectors.RegularVector;
import de.bioforscher.singa.mathematics.vectors.Vector;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.function.BiConsumer;
import java.util.stream.DoubleStream;

public interface Matrix
extends MultiDimensional<Matrix>,
Ring<Matrix> {
    public <M extends Matrix> M as(Class<M> var1);

    public Matrix transpose();

    @Override
    public Matrix multiply(double var1);

    @Override
    public Vector multiply(Vector var1);

    public Matrix hadamardMultiply(Matrix var1);

    public double[][] getElements();

    default public DoubleStream streamElements() {
        return Arrays.stream(this.getElements()).flatMapToDouble(Arrays::stream);
    }

    default public void forEach(BiConsumer<Pair<Integer>, Double> action) {
        for (int rowIndex = 0; rowIndex < this.getRowDimension(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < this.getColumnDimension(); ++columnIndex) {
                action.accept((Pair<Integer>)new Pair((Object)rowIndex, (Object)columnIndex), this.getElement(rowIndex, columnIndex));
            }
        }
    }

    default public <M extends Matrix> M getCopy() {
        double[][] copyOfElements = new double[this.getElements().length][];
        for (int i = 0; i < this.getElements().length; ++i) {
            double[] row = this.getElements()[i];
            copyOfElements[i] = new double[row.length];
            System.arraycopy(row, 0, copyOfElements[i], 0, row.length);
        }
        try {
            return (M)((Matrix)this.getClass().getConstructor(double[][].class).newInstance(new Object[]{copyOfElements}));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            throw new UnsupportedOperationException("Instance types must match to copy successfully.");
        }
    }

    public double getElement(int var1, int var2);

    public RegularVector getColumn(int var1);

    public int getColumnDimension();

    public RegularVector getRow(int var1);

    public int getRowDimension();

    default public boolean hasSameInnerDimension(Matrix matrix) {
        return this.getColumnDimension() == matrix.getRowDimension();
    }

    default public void assertThatInnerDimensionsMatch(Matrix matrix) {
        if (!this.hasSameInnerDimension(matrix)) {
            throw new IncompatibleDimensionsException(this, matrix);
        }
    }

    default public boolean hasSameInnerDimension(Vector vector) {
        return this.getColumnDimension() == vector.getDimension();
    }

    default public void assertThatInnerDimensionsMatch(Vector vector) {
        if (!this.hasSameInnerDimension(vector)) {
            throw new IncompatibleDimensionsException(this, vector);
        }
    }

    @Override
    default public boolean hasSameDimensions(Matrix matrix) {
        return this.getRowDimension() == matrix.getRowDimension() && this.getColumnDimension() == matrix.getColumnDimension();
    }
}

