/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.mathematics.matrices;

import de.bioforscher.singa.core.utility.Pair;
import de.bioforscher.singa.mathematics.algorithms.matrix.QRDecomposition;
import de.bioforscher.singa.mathematics.algorithms.matrix.SVDecomposition;
import de.bioforscher.singa.mathematics.matrices.LabeledMatrix;
import de.bioforscher.singa.mathematics.matrices.LabeledRegularMatrix;
import de.bioforscher.singa.mathematics.matrices.LabeledSymmetricMatrix;
import de.bioforscher.singa.mathematics.matrices.Matrix;
import de.bioforscher.singa.mathematics.matrices.RegularMatrix;
import de.bioforscher.singa.mathematics.matrices.SquareMatrix;
import de.bioforscher.singa.mathematics.matrices.SymmetricMatrix;
import de.bioforscher.singa.mathematics.vectors.Vector;
import de.bioforscher.singa.mathematics.vectors.Vectors;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class Matrices {
    private static final String DEFAULT_CSV_DELIMITER = ",";

    private Matrices() {
    }

    public static SquareMatrix generateIdentityMatrix(int size) {
        double[][] values = new double[size][size];
        for (int diagonalIndex = 0; diagonalIndex < size; ++diagonalIndex) {
            values[diagonalIndex][diagonalIndex] = 1.0;
        }
        return new SquareMatrix(values);
    }

    public static List<Vector> divideIntoColumns(Matrix matrix) {
        ArrayList<Vector> columns = new ArrayList<Vector>();
        for (int column = 0; column < matrix.getColumnDimension(); ++column) {
            columns.add(matrix.getColumn(column));
        }
        return columns;
    }

    public static Matrix assembleMatrixFromColumns(List<Vector> columnVectors) {
        if (!Vectors.haveSameDimension(columnVectors)) {
            throw new IllegalArgumentException("All vectors need to have the same dimension in order to create a matrix out of them.");
        }
        double[][] elements = new double[columnVectors.size()][columnVectors.get(0).getDimension()];
        for (int row = 0; row < columnVectors.size(); ++row) {
            elements[row] = columnVectors.get(row).getElements();
        }
        return new RegularMatrix(elements);
    }

    public static List<Vector> divideIntoRows(Matrix matrix) {
        ArrayList<Vector> rows = new ArrayList<Vector>();
        for (int row = 0; row < matrix.getRowDimension(); ++row) {
            rows.add(matrix.getRow(row));
        }
        return rows;
    }

    public static Matrix assembleMatrixFromRows(List<Vector> rowVectors) {
        if (!Vectors.haveSameDimension(rowVectors)) {
            throw new IllegalArgumentException("All vectors need to have the same dimension in order to create a matrix out of them.");
        }
        double[][] elements = new double[rowVectors.size()][rowVectors.get(0).getDimension()];
        for (int column = 0; column < rowVectors.size(); ++column) {
            elements[column] = rowVectors.get(column).getElements();
        }
        return new RegularMatrix(elements);
    }

    public static List<Pair<Integer>> getPositionsOfMinimalElement(Matrix matrix) {
        double minimalElement = Double.MAX_VALUE;
        ArrayList<Pair<Integer>> minimalElementPositions = new ArrayList<Pair<Integer>>();
        for (int i = 0; i < matrix.getRowDimension(); ++i) {
            for (int j = 0; j < matrix.getColumnDimension(); ++j) {
                double currentMatrixElement = matrix.getElement(i, j);
                if (Double.compare(currentMatrixElement, minimalElement) == 0) {
                    minimalElementPositions.add((Pair<Integer>)new Pair((Object)i, (Object)j));
                    continue;
                }
                if (Double.compare(currentMatrixElement, minimalElement) >= 0) continue;
                minimalElement = currentMatrixElement;
                minimalElementPositions.clear();
                minimalElementPositions.add((Pair<Integer>)new Pair((Object)i, (Object)j));
            }
        }
        return minimalElementPositions;
    }

    public static Optional<Pair<Integer>> getPositionOfMinimalElement(Matrix matrix) {
        List<Pair<Integer>> minimalElementPositions = Matrices.getPositionsOfMinimalElement(matrix);
        return minimalElementPositions.size() == 1 ? Optional.of(minimalElementPositions.get(0)) : Optional.empty();
    }

    public static List<Pair<Integer>> getPositionsOfMaximalElement(Matrix matrix) {
        double maximalElement = -1.7976931348623157E308;
        ArrayList<Pair<Integer>> maximalElementsPositions = new ArrayList<Pair<Integer>>();
        for (int i = 0; i < matrix.getColumnDimension(); ++i) {
            for (int j = 0; j < matrix.getRowDimension(); ++j) {
                double currentMatrixElement = matrix.getElement(i, j);
                if (Double.compare(currentMatrixElement, maximalElement) == 0) {
                    maximalElementsPositions.add((Pair<Integer>)new Pair((Object)i, (Object)j));
                    continue;
                }
                if (Double.compare(currentMatrixElement, maximalElement) <= 0) continue;
                maximalElement = currentMatrixElement;
                maximalElementsPositions.clear();
                maximalElementsPositions.add((Pair<Integer>)new Pair((Object)i, (Object)j));
            }
        }
        return maximalElementsPositions;
    }

    public static Optional<Pair<Integer>> getPositionOfMaximalElement(Matrix matrix) {
        List<Pair<Integer>> maximalElementPositions = Matrices.getPositionsOfMaximalElement(matrix);
        return maximalElementPositions.size() == 1 ? Optional.of(maximalElementPositions.get(0)) : Optional.empty();
    }

    public static QRDecomposition performQRDecomposition(Matrix matrix) {
        return QRDecomposition.calculateQRDecomposition(matrix);
    }

    public static LabeledMatrix<String> readLabeledMatrixFromCSV(Stream<String> csvLines, String delimiter) {
        List rawRows = csvLines.map(line -> line.split(delimiter)).map(splittedLine -> Arrays.stream(splittedLine).filter(cell -> !cell.isEmpty()).collect(Collectors.toList()).toArray(new String[0])).collect(Collectors.toList());
        List distinctRowLengths = rawRows.stream().map(rawRow -> ((String[])rawRow).length).distinct().collect(Collectors.toList());
        List rowLengths = rawRows.stream().map(rawRow -> ((String[])rawRow).length).collect(Collectors.toList());
        boolean triangularUpper = true;
        boolean triangularLower = true;
        for (int i = 1; i < rowLengths.size() - 1; ++i) {
            if ((Integer)rowLengths.get(i + 1) != (Integer)rowLengths.get(i) + 1) {
                triangularLower = false;
            }
            if ((Integer)rowLengths.get(i + 1) == (Integer)rowLengths.get(i) - 1) continue;
            triangularUpper = false;
        }
        ArrayList<String[]> rawColumns = new ArrayList<String[]>();
        if (distinctRowLengths.size() == 2 && (Integer)distinctRowLengths.get(0) == (Integer)distinctRowLengths.get(1) - 1) {
            List<Object> columnLabels = Arrays.asList((Object[])rawRows.get(0));
            int rowLength = ((String[])rawRows.get(1)).length;
            for (int i = 0; i < rowLength; ++i) {
                String[] rawColumn = new String[rawRows.size() - 1];
                for (int j = 1; j < rawRows.size(); ++j) {
                    rawColumn[j - 1] = ((String[])rawRows.get(j))[i];
                }
                rawColumns.add(rawColumn);
            }
            List<Object> rowLabels = Arrays.asList((Object[])rawColumns.get(0));
            double[][] values = new double[rawRows.size() - 1][rawColumns.size() - 1];
            for (int i = 1; i < rawRows.size(); ++i) {
                for (int j = 1; j < rawColumns.size(); ++j) {
                    double value;
                    values[i - 1][j - 1] = value = Double.valueOf(((String[])rawRows.get(i))[j]).doubleValue();
                }
            }
            if (SymmetricMatrix.isSymmetric(values)) {
                LabeledSymmetricMatrix<String> labeledSymmetricMatrix = new LabeledSymmetricMatrix<String>(values);
                labeledSymmetricMatrix.setColumnLabels(columnLabels);
                return labeledSymmetricMatrix;
            }
            LabeledRegularMatrix<String> labeledRegularMatrix = new LabeledRegularMatrix<String>(values);
            labeledRegularMatrix.setColumnLabels(columnLabels);
            labeledRegularMatrix.setRowLabels(rowLabels);
            return labeledRegularMatrix;
        }
        if (triangularLower || triangularUpper) {
            int i;
            List<Object> columnLabels = Arrays.asList((Object[])rawRows.get(0));
            double[][] values = new double[rawRows.size() - 1][rawRows.size() - 1];
            if (triangularLower) {
                for (i = rawRows.size() - 1; i > 0; --i) {
                    for (int j = 1; j < i + 1; ++j) {
                        double value;
                        values[i - 1][j - 1] = value = Double.valueOf(((String[])rawRows.get(i))[j]).doubleValue();
                        values[j - 1][i - 1] = value;
                    }
                }
            } else {
                for (i = 1; i < rawRows.size(); ++i) {
                    for (int j = 1; j < rawRows.size() - i + 1; ++j) {
                        double value;
                        values[i - 1][j + i - 2] = value = Double.valueOf(((String[])rawRows.get(i))[j]).doubleValue();
                        values[j + i - 2][i - 1] = value;
                    }
                }
            }
            if (SymmetricMatrix.isSymmetric(values)) {
                LabeledSymmetricMatrix<String> labeledSymmetricMatrix = new LabeledSymmetricMatrix<String>(values);
                labeledSymmetricMatrix.setColumnLabels(columnLabels);
                return labeledSymmetricMatrix;
            }
            throw new IllegalArgumentException("triangular matrix has to be symmetric");
        }
        throw new IllegalArgumentException("labeling seems to be incorrect");
    }

    public static Matrix readUnlabeledMatrixFromCSV(Stream<String> csvLines, String delimiter) {
        boolean columnsOfSameLength;
        boolean rowsOfSameLength;
        List rawRows = csvLines.map(line -> line.split(delimiter)).map(splittedLine -> (String[])Arrays.stream(splittedLine).filter(cell -> !cell.isEmpty()).toArray(String[]::new)).collect(Collectors.toList());
        boolean bl = rowsOfSameLength = rawRows.stream().map(rawRow -> ((String[])rawRow).length).distinct().count() == 1L;
        if (!rowsOfSameLength) {
            throw new IllegalArgumentException("rows seem to contain missing values");
        }
        int rowLength = ((String[])rawRows.get(0)).length;
        ArrayList<String[]> rawColumns = new ArrayList<String[]>();
        for (int i = 0; i < rowLength; ++i) {
            String[] rawColumn2 = new String[rawRows.size()];
            for (int j = 0; j < rawRows.size(); ++j) {
                rawColumn2[j] = ((String[])rawRows.get(j))[i];
            }
            rawColumns.add(rawColumn2);
        }
        boolean bl2 = columnsOfSameLength = rawColumns.stream().map(rawColumn -> ((String[])rawColumn).length).distinct().count() == 1L;
        if (!columnsOfSameLength) {
            throw new IllegalArgumentException("columns seem to contain missing values");
        }
        double[][] values = new double[rawRows.size()][rawColumns.size()];
        for (int i = 0; i < rawRows.size(); ++i) {
            for (int j = 0; j < rawColumns.size(); ++j) {
                double value;
                values[i][j] = value = Double.valueOf(((String[])rawRows.get(i))[j]).doubleValue();
            }
        }
        if (SymmetricMatrix.isSymmetric(values)) {
            return new SymmetricMatrix(values);
        }
        if (SquareMatrix.isSquare(values)) {
            return new SquareMatrix(values);
        }
        return new RegularMatrix(values);
    }

    public static LabeledMatrix<String> readLabeledMatrixFromCSV(InputStream inputStream, String delimiter) throws IOException {
        try (BufferedReader buffer = new BufferedReader(new InputStreamReader(inputStream));){
            LabeledMatrix<String> labeledMatrix = Matrices.readLabeledMatrixFromCSV(buffer.lines(), delimiter);
            return labeledMatrix;
        }
    }

    public static LabeledMatrix<String> readLabeledMatrixFromCSV(InputStream inputStream) throws IOException {
        try (BufferedReader buffer = new BufferedReader(new InputStreamReader(inputStream));){
            LabeledMatrix<String> labeledMatrix = Matrices.readLabeledMatrixFromCSV(buffer.lines(), DEFAULT_CSV_DELIMITER);
            return labeledMatrix;
        }
    }

    public static LabeledMatrix<String> readLabeledMatrixFromCSV(Path path) throws IOException {
        return Matrices.readLabeledMatrixFromCSV(Files.lines(path), DEFAULT_CSV_DELIMITER);
    }

    public static LabeledMatrix<String> readLabeledMatrixFromCSV(Path path, String delimiter) throws IOException {
        return Matrices.readLabeledMatrixFromCSV(Files.lines(path), delimiter);
    }

    public static Matrix readUnlabeledMatrixFromCSV(Path path, String delimiter) throws IOException {
        return Matrices.readUnlabeledMatrixFromCSV(Files.lines(path), delimiter);
    }

    public static Matrix readUnlabeledMatrixFromCSV(Path path) throws IOException {
        return Matrices.readUnlabeledMatrixFromCSV(path, DEFAULT_CSV_DELIMITER);
    }

    public static Matrix calculateCovarianceMatrix(Matrix a, Matrix b) {
        return b.transpose().multiply(a);
    }

    public static SVDecomposition performSVDecomposition(Matrix matrix) {
        return new SVDecomposition(matrix);
    }
}

