/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.mathematics.graphs.voronoi;

import de.bioforscher.singa.mathematics.graphs.voronoi.Edge;
import de.bioforscher.singa.mathematics.graphs.voronoi.Halfedge;
import de.bioforscher.singa.mathematics.graphs.voronoi.Point;
import de.bioforscher.singa.mathematics.graphs.voronoi.Site;
import de.bioforscher.singa.mathematics.graphs.voronoi.VoronoiFaceEdge;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

public class Voronoi {
    private double borderMinX;
    private double borderMaxX;
    private double borderMinY;
    private double borderMaxY;
    private int siteidx = 0;
    private double xmin;
    private double xmax;
    private double ymin;
    private double ymax;
    private double deltax;
    private double deltay;
    private int nvertices;
    private int nedges;
    private int nsites;
    private Site[] sites = null;
    private Site bottomsite;
    private int sqrt_nsites;
    private double minDistanceBetweenSites;
    private int PQcount;
    private int PQmin;
    private int PQhashsize;
    private Halfedge[] PQhash;
    private static final int LE = 0;
    private static final int RE = 1;
    private int ELhashsize;
    private Halfedge[] ELhash;
    private Halfedge ELleftend;
    private Halfedge ELrightend;
    private List<VoronoiFaceEdge> allEdges = null;

    public Voronoi(double minDistanceBetweenSites) {
        this.minDistanceBetweenSites = minDistanceBetweenSites;
    }

    public List<VoronoiFaceEdge> generateVoronoi(double[] xValuesIn, double[] yValuesIn, double minX, double maxX, double minY, double maxY) {
        this.sort(xValuesIn, yValuesIn, xValuesIn.length);
        double temp = 0.0;
        if (minX > maxX) {
            temp = minX;
            minX = maxX;
            maxX = temp;
        }
        if (minY > maxY) {
            temp = minY;
            minY = maxY;
            maxY = temp;
        }
        this.borderMinX = minX;
        this.borderMinY = minY;
        this.borderMaxX = maxX;
        this.borderMaxY = maxY;
        this.siteidx = 0;
        this.voronoi_bd();
        return this.allEdges;
    }

    private void sort(double[] xValuesIn, double[] yValuesIn, int count) {
        this.allEdges = new LinkedList<VoronoiFaceEdge>();
        this.nsites = count;
        this.nvertices = 0;
        this.nedges = 0;
        this.sqrt_nsites = (int)Math.sqrt((double)this.nsites + 4.0);
        double[] xValues = new double[count];
        double[] yValues = new double[count];
        for (int i = 0; i < count; ++i) {
            xValues[i] = xValuesIn[i];
            yValues[i] = yValuesIn[i];
        }
        this.sortNode(xValues, yValues, count);
    }

    private void qsort(Site[] sites) {
        ArrayList<Site> listSites = new ArrayList<Site>(sites.length);
        for (Site s : sites) {
            listSites.add(s);
        }
        Collections.sort(listSites, new Comparator<Site>(){

            @Override
            public final int compare(Site p1, Site p2) {
                Point s1 = p1.coord;
                Point s2 = p2.coord;
                if (s1.y < s2.y) {
                    return -1;
                }
                if (s1.y > s2.y) {
                    return 1;
                }
                if (s1.x < s2.x) {
                    return -1;
                }
                if (s1.x > s2.x) {
                    return 1;
                }
                return 0;
            }
        });
        for (int i = 0; i < sites.length; ++i) {
            sites[i] = (Site)listSites.get(i);
        }
    }

    private void sortNode(double[] xValues, double[] yValues, int numPoints) {
        this.nsites = numPoints;
        this.sites = new Site[this.nsites];
        this.xmin = xValues[0];
        this.ymin = yValues[0];
        this.xmax = xValues[0];
        this.ymax = yValues[0];
        for (int i = 0; i < this.nsites; ++i) {
            this.sites[i] = new Site();
            this.sites[i].coord.setPoint(xValues[i], yValues[i]);
            this.sites[i].sitenbr = i;
            if (xValues[i] < this.xmin) {
                this.xmin = xValues[i];
            } else if (xValues[i] > this.xmax) {
                this.xmax = xValues[i];
            }
            if (yValues[i] < this.ymin) {
                this.ymin = yValues[i];
                continue;
            }
            if (!(yValues[i] > this.ymax)) continue;
            this.ymax = yValues[i];
        }
        this.qsort(this.sites);
        this.deltay = this.ymax - this.ymin;
        this.deltax = this.xmax - this.xmin;
    }

    private Site nextone() {
        if (this.siteidx < this.nsites) {
            Site s = this.sites[this.siteidx];
            ++this.siteidx;
            return s;
        }
        return null;
    }

    private Edge bisect(Site s1, Site s2) {
        Edge newedge = new Edge();
        newedge.reg[0] = s1;
        newedge.reg[1] = s2;
        newedge.ep[0] = null;
        newedge.ep[1] = null;
        double dx = s2.coord.x - s1.coord.x;
        double dy = s2.coord.y - s1.coord.y;
        double adx = dx > 0.0 ? dx : -dx;
        double ady = dy > 0.0 ? dy : -dy;
        newedge.c = s1.coord.x * dx + s1.coord.y * dy + (dx * dx + dy * dy) * 0.5;
        if (adx > ady) {
            newedge.a = 1.0;
            newedge.b = dy / dx;
            newedge.c /= dx;
        } else {
            newedge.b = 1.0;
            newedge.a = dx / dy;
            newedge.c /= dy;
        }
        newedge.edgenbr = this.nedges++;
        return newedge;
    }

    private void makevertex(Site v) {
        v.sitenbr = this.nvertices++;
    }

    private boolean PQinitialize() {
        this.PQcount = 0;
        this.PQmin = 0;
        this.PQhashsize = 4 * this.sqrt_nsites;
        this.PQhash = new Halfedge[this.PQhashsize];
        for (int i = 0; i < this.PQhashsize; ++i) {
            this.PQhash[i] = new Halfedge();
        }
        return true;
    }

    private int PQbucket(Halfedge he) {
        int bucket = (int)((he.ystar - this.ymin) / this.deltay * (double)this.PQhashsize);
        if (bucket < 0) {
            bucket = 0;
        }
        if (bucket >= this.PQhashsize) {
            bucket = this.PQhashsize - 1;
        }
        if (bucket < this.PQmin) {
            this.PQmin = bucket;
        }
        return bucket;
    }

    private void PQinsert(Halfedge he, Site v, double offset) {
        Halfedge next;
        he.vertex = v;
        he.ystar = v.coord.y + offset;
        Halfedge last = this.PQhash[this.PQbucket(he)];
        while ((next = last.PQnext) != null && (he.ystar > next.ystar || he.ystar == next.ystar && v.coord.x > next.vertex.coord.x)) {
            last = next;
        }
        he.PQnext = last.PQnext;
        last.PQnext = he;
        ++this.PQcount;
    }

    private void PQdelete(Halfedge he) {
        if (he.vertex != null) {
            Halfedge last = this.PQhash[this.PQbucket(he)];
            while (last.PQnext != he) {
                last = last.PQnext;
            }
            last.PQnext = he.PQnext;
            --this.PQcount;
            he.vertex = null;
        }
    }

    private boolean PQempty() {
        return this.PQcount == 0;
    }

    private Point PQ_min() {
        Point answer = new Point();
        while (this.PQhash[this.PQmin].PQnext == null) {
            ++this.PQmin;
        }
        answer.x = this.PQhash[this.PQmin].PQnext.vertex.coord.x;
        answer.y = this.PQhash[this.PQmin].PQnext.ystar;
        return answer;
    }

    private Halfedge PQextractmin() {
        Halfedge curr = this.PQhash[this.PQmin].PQnext;
        this.PQhash[this.PQmin].PQnext = curr.PQnext;
        --this.PQcount;
        return curr;
    }

    private Halfedge HEcreate(Edge e, int pm) {
        Halfedge answer = new Halfedge();
        answer.ELedge = e;
        answer.ELpm = pm;
        answer.PQnext = null;
        answer.vertex = null;
        return answer;
    }

    private boolean ELinitialize() {
        this.ELhashsize = 2 * this.sqrt_nsites;
        this.ELhash = new Halfedge[this.ELhashsize];
        for (int i = 0; i < this.ELhashsize; ++i) {
            this.ELhash[i] = null;
        }
        this.ELleftend = this.HEcreate(null, 0);
        this.ELrightend = this.HEcreate(null, 0);
        this.ELleftend.ELleft = null;
        this.ELleftend.ELright = this.ELrightend;
        this.ELrightend.ELleft = this.ELleftend;
        this.ELrightend.ELright = null;
        this.ELhash[0] = this.ELleftend;
        this.ELhash[this.ELhashsize - 1] = this.ELrightend;
        return true;
    }

    private Halfedge ELright(Halfedge he) {
        return he.ELright;
    }

    private Halfedge ELleft(Halfedge he) {
        return he.ELleft;
    }

    private Site leftreg(Halfedge he) {
        if (he.ELedge == null) {
            return this.bottomsite;
        }
        return he.ELpm == 0 ? he.ELedge.reg[0] : he.ELedge.reg[1];
    }

    private void ELinsert(Halfedge lb, Halfedge newHe) {
        newHe.ELleft = lb;
        newHe.ELright = lb.ELright;
        lb.ELright.ELleft = newHe;
        lb.ELright = newHe;
    }

    private void ELdelete(Halfedge he) {
        he.ELleft.ELright = he.ELright;
        he.ELright.ELleft = he.ELleft;
        he.deleted = true;
    }

    private Halfedge ELgethash(int b) {
        if (b < 0 || b >= this.ELhashsize) {
            return null;
        }
        Halfedge he = this.ELhash[b];
        if (he == null || !he.deleted) {
            return he;
        }
        this.ELhash[b] = null;
        return null;
    }

    private Halfedge ELleftbnd(Point p) {
        Halfedge he;
        int bucket = (int)((p.x - this.xmin) / this.deltax * (double)this.ELhashsize);
        if (bucket < 0) {
            bucket = 0;
        }
        if (bucket >= this.ELhashsize) {
            bucket = this.ELhashsize - 1;
        }
        if ((he = this.ELgethash(bucket)) == null) {
            for (int i = 1; i < this.ELhashsize && (he = this.ELgethash(bucket - i)) == null && (he = this.ELgethash(bucket + i)) == null; ++i) {
            }
        }
        if (he == this.ELleftend || he != this.ELrightend && this.right_of(he, p)) {
            while ((he = he.ELright) != this.ELrightend && this.right_of(he, p)) {
            }
            he = he.ELleft;
        } else {
            while ((he = he.ELleft) != this.ELleftend && !this.right_of(he, p)) {
            }
        }
        if (bucket > 0 && bucket < this.ELhashsize - 1) {
            this.ELhash[bucket] = he;
        }
        return he;
    }

    private void pushGraphEdge(Site leftSite, Site rightSite, double x1, double y1, double x2, double y2) {
        VoronoiFaceEdge newEdge = new VoronoiFaceEdge();
        this.allEdges.add(newEdge);
        newEdge.x1 = x1;
        newEdge.y1 = y1;
        newEdge.x2 = x2;
        newEdge.y2 = y2;
        newEdge.site1 = leftSite.sitenbr;
        newEdge.site2 = rightSite.sitenbr;
    }

    private void clip_line(Edge e) {
        Site s2;
        Site s1;
        double x1 = 0.0;
        double x2 = 0.0;
        double y1 = 0.0;
        double y2 = 0.0;
        x2 = e.reg[1].coord.x;
        x1 = e.reg[0].coord.x;
        y2 = e.reg[1].coord.y;
        y1 = e.reg[0].coord.y;
        if (Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1)) < this.minDistanceBetweenSites) {
            return;
        }
        double pxmin = this.borderMinX;
        double pxmax = this.borderMaxX;
        double pymin = this.borderMinY;
        double pymax = this.borderMaxY;
        if (e.a == 1.0 && e.b >= 0.0) {
            s1 = e.ep[1];
            s2 = e.ep[0];
        } else {
            s1 = e.ep[0];
            s2 = e.ep[1];
        }
        if (e.a == 1.0) {
            y1 = pymin;
            if (s1 != null && s1.coord.y > pymin) {
                y1 = s1.coord.y;
            }
            if (y1 > pymax) {
                y1 = pymax;
            }
            x1 = e.c - e.b * y1;
            y2 = pymax;
            if (s2 != null && s2.coord.y < pymax) {
                y2 = s2.coord.y;
            }
            if (y2 < pymin) {
                y2 = pymin;
            }
            if (x1 > pxmax & (x2 = e.c - e.b * y2) > pxmax | x1 < pxmin & x2 < pxmin) {
                return;
            }
            if (x1 > pxmax) {
                x1 = pxmax;
                y1 = (e.c - x1) / e.b;
            }
            if (x1 < pxmin) {
                x1 = pxmin;
                y1 = (e.c - x1) / e.b;
            }
            if (x2 > pxmax) {
                x2 = pxmax;
                y2 = (e.c - x2) / e.b;
            }
            if (x2 < pxmin) {
                x2 = pxmin;
                y2 = (e.c - x2) / e.b;
            }
        } else {
            x1 = pxmin;
            if (s1 != null && s1.coord.x > pxmin) {
                x1 = s1.coord.x;
            }
            if (x1 > pxmax) {
                x1 = pxmax;
            }
            y1 = e.c - e.a * x1;
            x2 = pxmax;
            if (s2 != null && s2.coord.x < pxmax) {
                x2 = s2.coord.x;
            }
            if (x2 < pxmin) {
                x2 = pxmin;
            }
            if (y1 > pymax & (y2 = e.c - e.a * x2) > pymax | y1 < pymin & y2 < pymin) {
                return;
            }
            if (y1 > pymax) {
                y1 = pymax;
                x1 = (e.c - y1) / e.a;
            }
            if (y1 < pymin) {
                y1 = pymin;
                x1 = (e.c - y1) / e.a;
            }
            if (y2 > pymax) {
                y2 = pymax;
                x2 = (e.c - y2) / e.a;
            }
            if (y2 < pymin) {
                y2 = pymin;
                x2 = (e.c - y2) / e.a;
            }
        }
        this.pushGraphEdge(e.reg[0], e.reg[1], x1, y1, x2, y2);
    }

    private void endpoint(Edge e, int lr, Site s) {
        e.ep[lr] = s;
        if (e.ep[1 - lr] == null) {
            return;
        }
        this.clip_line(e);
    }

    private boolean right_of(Halfedge el, Point p) {
        boolean above;
        boolean right_of_site;
        Edge e = el.ELedge;
        Site topsite = e.reg[1];
        boolean bl = right_of_site = p.x > topsite.coord.x;
        if (right_of_site && el.ELpm == 0) {
            return true;
        }
        if (!right_of_site && el.ELpm == 1) {
            return false;
        }
        if (e.a == 1.0) {
            double dyp = p.y - topsite.coord.y;
            double dxp = p.x - topsite.coord.x;
            boolean fast = false;
            if (!right_of_site & e.b < 0.0 | right_of_site & e.b >= 0.0) {
                fast = above = dyp >= e.b * dxp;
            } else {
                boolean bl2 = above = p.x + p.y * e.b > e.c;
                if (e.b < 0.0) {
                    boolean bl3 = above = !above;
                }
                if (!above) {
                    fast = true;
                }
            }
            if (!fast) {
                double dxs = topsite.coord.x - e.reg[0].coord.x;
                boolean bl4 = above = e.b * (dxp * dxp - dyp * dyp) < dxs * dyp * (1.0 + 2.0 * dxp / dxs + e.b * e.b);
                if (e.b < 0.0) {
                    above = !above;
                }
            }
        } else {
            double yl = e.c - e.a * p.x;
            double t1 = p.y - yl;
            double t2 = p.x - topsite.coord.x;
            double t3 = yl - topsite.coord.y;
            above = t1 * t1 > t2 * t2 + t3 * t3;
        }
        return el.ELpm == 0 == above;
    }

    private Site rightreg(Halfedge he) {
        if (he.ELedge == null) {
            return this.bottomsite;
        }
        return he.ELpm == 0 ? he.ELedge.reg[1] : he.ELedge.reg[0];
    }

    private double dist(Site s, Site t) {
        double dx = s.coord.x - t.coord.x;
        double dy = s.coord.y - t.coord.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    private Site intersect(Halfedge el1, Halfedge el2) {
        boolean right_of_site;
        Edge e;
        Halfedge el;
        Edge e1 = el1.ELedge;
        Edge e2 = el2.ELedge;
        if (e1 == null || e2 == null) {
            return null;
        }
        if (e1.reg[1] == e2.reg[1]) {
            return null;
        }
        double d = e1.a * e2.b - e1.b * e2.a;
        if (-1.0E-10 < d && d < 1.0E-10) {
            return null;
        }
        double xint = (e1.c * e2.b - e2.c * e1.b) / d;
        double yint = (e2.c * e1.a - e1.c * e2.a) / d;
        if (e1.reg[1].coord.y < e2.reg[1].coord.y || e1.reg[1].coord.y == e2.reg[1].coord.y && e1.reg[1].coord.x < e2.reg[1].coord.x) {
            el = el1;
            e = e1;
        } else {
            el = el2;
            e = e2;
        }
        boolean bl = right_of_site = xint >= e.reg[1].coord.x;
        if (right_of_site && el.ELpm == 0 || !right_of_site && el.ELpm == 1) {
            return null;
        }
        Site v = new Site();
        v.coord.x = xint;
        v.coord.y = yint;
        return v;
    }

    private boolean voronoi_bd() {
        Edge e;
        Halfedge lbnd;
        Point newintstar = null;
        this.PQinitialize();
        this.ELinitialize();
        this.bottomsite = this.nextone();
        Site newsite = this.nextone();
        while (true) {
            Site p;
            Halfedge bisector;
            Site bot;
            Halfedge rbnd;
            if (!this.PQempty()) {
                newintstar = this.PQ_min();
            }
            if (newsite != null && (this.PQempty() || newsite.coord.y < newintstar.y || newsite.coord.y == newintstar.y && newsite.coord.x < newintstar.x)) {
                lbnd = this.ELleftbnd(newsite.coord);
                rbnd = this.ELright(lbnd);
                bot = this.rightreg(lbnd);
                e = this.bisect(bot, newsite);
                bisector = this.HEcreate(e, 0);
                this.ELinsert(lbnd, bisector);
                p = this.intersect(lbnd, bisector);
                if (p != null) {
                    this.PQdelete(lbnd);
                    this.PQinsert(lbnd, p, this.dist(p, newsite));
                }
                lbnd = bisector;
                bisector = this.HEcreate(e, 1);
                this.ELinsert(lbnd, bisector);
                p = this.intersect(bisector, rbnd);
                if (p != null) {
                    this.PQinsert(bisector, p, this.dist(p, newsite));
                }
                newsite = this.nextone();
                continue;
            }
            if (this.PQempty()) break;
            lbnd = this.PQextractmin();
            Halfedge llbnd = this.ELleft(lbnd);
            rbnd = this.ELright(lbnd);
            Halfedge rrbnd = this.ELright(rbnd);
            bot = this.leftreg(lbnd);
            Site top = this.rightreg(rbnd);
            Site v = lbnd.vertex;
            this.makevertex(v);
            this.endpoint(lbnd.ELedge, lbnd.ELpm, v);
            this.endpoint(rbnd.ELedge, rbnd.ELpm, v);
            this.ELdelete(lbnd);
            this.PQdelete(rbnd);
            this.ELdelete(rbnd);
            int pm = 0;
            if (bot.coord.y > top.coord.y) {
                Site temp = bot;
                bot = top;
                top = temp;
                pm = 1;
            }
            e = this.bisect(bot, top);
            bisector = this.HEcreate(e, pm);
            this.ELinsert(llbnd, bisector);
            this.endpoint(e, 1 - pm, v);
            p = this.intersect(llbnd, bisector);
            if (p != null) {
                this.PQdelete(llbnd);
                this.PQinsert(llbnd, p, this.dist(p, bot));
            }
            if ((p = this.intersect(bisector, rrbnd)) == null) continue;
            this.PQinsert(bisector, p, this.dist(p, bot));
        }
        lbnd = this.ELright(this.ELleftend);
        while (lbnd != this.ELrightend) {
            e = lbnd.ELedge;
            this.clip_line(e);
            lbnd = this.ELright(lbnd);
        }
        return true;
    }
}

