/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.mathematics.graphs.trees;

import de.bioforscher.singa.mathematics.graphs.trees.BinaryTreeNode;
import de.bioforscher.singa.mathematics.matrices.LabeledSymmetricMatrix;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class BinaryTree<T>
implements Serializable {
    private static final long serialVersionUID = 7841821945964241393L;
    private BinaryTreeNode<T> root;
    private LabeledSymmetricMatrix<String> distanceMatrix;

    public BinaryTree(BinaryTreeNode<T> root) {
        this.root = root;
    }

    public LabeledSymmetricMatrix<String> getDistanceMatrix() {
        return this.distanceMatrix;
    }

    public void setDistanceMatrix(LabeledSymmetricMatrix<String> distanceMatrix) {
        this.distanceMatrix = distanceMatrix;
    }

    public void collectLeavesPreOrder(BinaryTreeNode<T> startingNode, List<BinaryTreeNode<T>> leaveNodes) {
        if (startingNode != null) {
            BinaryTreeNode<T> left = startingNode.getLeft();
            BinaryTreeNode<T> right = startingNode.getRight();
            if (left == null && right == null) {
                leaveNodes.add(startingNode);
            }
            this.collectLeavesPreOrder(left, leaveNodes);
            this.collectLeavesPreOrder(right, leaveNodes);
        }
    }

    public void collectNodesPreOrder(BinaryTreeNode<T> startingNode, List<BinaryTreeNode<T>> nodes) {
        if (startingNode != null) {
            BinaryTreeNode<T> left = startingNode.getLeft();
            BinaryTreeNode<T> right = startingNode.getRight();
            nodes.add(startingNode);
            this.collectNodesPreOrder(left, nodes);
            this.collectNodesPreOrder(right, nodes);
        }
    }

    public List<BinaryTreeNode<T>> getLeafNodes() {
        ArrayList<BinaryTreeNode<T>> leaveNodes = new ArrayList<BinaryTreeNode<T>>();
        this.collectLeavesPreOrder(this.root, leaveNodes);
        return leaveNodes;
    }

    public BinaryTreeNode<T> getRoot() {
        return this.root;
    }

    public void setRoot(BinaryTreeNode<T> root) {
        this.root = root;
    }

    public BinaryTreeNode<T> findNode(T data) {
        return this.root.findNode(data);
    }

    public int size() {
        return this.root.size();
    }

    public String toNewickString() {
        return this.root.toNewickString() + ";";
    }

    public boolean containsNode(T nodeData) {
        return this.findNode(nodeData) != null;
    }

    public void appendNodeTo(BinaryTreeNode<T> parentNode, T childData) {
        this.appendNodeTo(parentNode.getData(), childData);
    }

    public void appendNodeTo(T parentData, T childData) {
        BinaryTreeNode<T> parentNode = this.findNode(parentData);
        if (parentNode.getLeft() != null && parentNode.getRight() != null) {
            throw new IllegalStateException("Both child nodes of " + parentNode + "are occupied. Unable to append additional child.");
        }
        if (parentNode.getLeft() == null) {
            parentNode.setLeft(new BinaryTreeNode<T>(childData));
        } else {
            parentNode.setRight(new BinaryTreeNode<T>(childData));
        }
    }

    public String toString() {
        return this.root.toStringInOrder();
    }
}

