/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.mathematics.graphs.model;

import de.bioforscher.singa.mathematics.graphs.model.Edge;
import de.bioforscher.singa.mathematics.graphs.model.Node;
import de.bioforscher.singa.mathematics.vectors.Vector;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;

public interface Graph<NodeType extends Node<NodeType, ? extends Vector, IdentifierType>, EdgeType extends Edge<NodeType>, IdentifierType> {
    public Collection<NodeType> getNodes();

    public NodeType getNode(IdentifierType var1);

    public IdentifierType addNode(NodeType var1);

    public NodeType removeNode(NodeType var1);

    public NodeType removeNode(IdentifierType var1);

    public Collection<EdgeType> getEdges();

    public EdgeType getEdge(int var1);

    public int addEdgeBetween(int var1, NodeType var2, NodeType var3);

    public int addEdgeBetween(EdgeType var1, NodeType var2, NodeType var3);

    public int addEdgeBetween(NodeType var1, NodeType var2);

    default public EdgeType getEdgeBetween(NodeType source, NodeType target) {
        return (EdgeType)this.getEdges().stream().filter(edge -> edge.containsNode(source) && edge.containsNode(target)).findAny().orElseThrow(() -> new IllegalStateException("Could not find any edge connecting " + source + " and " + target + "."));
    }

    public boolean containsNode(Object var1);

    public boolean containsEdge(Object var1);

    public IdentifierType nextNodeIdentifier();

    default public int nextEdgeIdentifier() {
        if (this.getEdges().isEmpty()) {
            return 0;
        }
        return this.getEdges().size() + 1;
    }

    default public <G extends Graph<NodeType, EdgeType, IdentifierType>> G getCopy() {
        try {
            return (G)((Graph)this.getClass().getConstructor(this.getClass()).newInstance(this));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            throw new UnsupportedOperationException("Instance types must match to copy successfully.");
        }
    }
}

