/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.mathematics.graphs.model;

import de.bioforscher.singa.mathematics.graphs.model.Edge;
import de.bioforscher.singa.mathematics.graphs.model.Graph;
import de.bioforscher.singa.mathematics.graphs.model.Node;
import de.bioforscher.singa.mathematics.vectors.Vector;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractGraph<NodeType extends Node<NodeType, VectorType, IdentifierType>, EdgeType extends Edge<NodeType>, VectorType extends Vector, IdentifierType>
implements Graph<NodeType, EdgeType, IdentifierType> {
    private int nextEdgeIdentifier;
    private Map<IdentifierType, NodeType> nodes;
    private Map<Integer, EdgeType> edges;

    public AbstractGraph() {
        this(10, 10);
    }

    public AbstractGraph(int nodeCapacity, int edgeCapacity) {
        this.nodes = new HashMap<IdentifierType, NodeType>(nodeCapacity);
        this.edges = new HashMap<Integer, EdgeType>(edgeCapacity);
    }

    @Override
    public Collection<NodeType> getNodes() {
        return this.nodes.values();
    }

    @Override
    public NodeType getNode(IdentifierType identifier) {
        return (NodeType)((Node)this.nodes.get(identifier));
    }

    @Override
    public IdentifierType addNode(NodeType node) {
        this.nodes.put(node.getIdentifier(), node);
        return node.getIdentifier();
    }

    @Override
    public NodeType removeNode(NodeType node) {
        Node nodeToBeRemoved = this.nodes.values().stream().filter(entry -> entry.equals(node)).findAny().orElseThrow(() -> new IllegalArgumentException("Could not remove node " + node + "."));
        for (Node neighbor : nodeToBeRemoved.getNeighbours()) {
            neighbor.getNeighbours().remove(nodeToBeRemoved);
        }
        this.nodes.remove(node.getIdentifier());
        this.edges.entrySet().removeIf(edge -> ((Edge)edge.getValue()).containsNode(node));
        return (NodeType)nodeToBeRemoved;
    }

    @Override
    public NodeType removeNode(IdentifierType identifier) {
        Node nodeToBeRemoved = this.nodes.values().stream().filter(entry -> entry.getIdentifier().equals(identifier)).findAny().orElseThrow(() -> new IllegalArgumentException("Could not remove node with identifier" + identifier + "."));
        for (Node neighbor : nodeToBeRemoved.getNeighbours()) {
            neighbor.getNeighbours().remove(nodeToBeRemoved);
        }
        this.nodes.remove(identifier);
        this.edges.entrySet().removeIf(edge -> ((Edge)edge.getValue()).containsNode(nodeToBeRemoved));
        return (NodeType)nodeToBeRemoved;
    }

    @Override
    public int nextEdgeIdentifier() {
        return this.nextEdgeIdentifier++;
    }

    @Override
    public Collection<EdgeType> getEdges() {
        return this.edges.values();
    }

    @Override
    public EdgeType getEdge(int identifier) {
        return (EdgeType)((Edge)this.edges.get(identifier));
    }

    @Override
    public int addEdgeBetween(EdgeType edge, NodeType source, NodeType target) {
        edge.setSource(source);
        edge.setTarget(target);
        this.edges.put(edge.getIdentifier(), edge);
        source.addNeighbour(target);
        target.addNeighbour(source);
        return edge.getIdentifier();
    }

    @Override
    public abstract int addEdgeBetween(int var1, NodeType var2, NodeType var3);

    @Override
    public abstract int addEdgeBetween(NodeType var1, NodeType var2);

    @Override
    public boolean containsNode(Object node) {
        return this.nodes.containsValue(node);
    }

    @Override
    public boolean containsEdge(Object edge) {
        return this.edges.containsValue(edge);
    }

    public int getMaximumDegree() {
        return this.nodes.values().stream().mapToInt(Node::getDegree).max().orElse(0);
    }

    public String toString() {
        return "Graph [contains " + this.nodes.size() + " nodes and " + this.edges.size() + " edges]";
    }
}

