/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.mathematics.graphs.model;

import de.bioforscher.singa.mathematics.graphs.model.Edge;
import de.bioforscher.singa.mathematics.graphs.model.Node;
import de.bioforscher.singa.mathematics.vectors.Vector;

public abstract class AbstractEdge<NodeType extends Node<NodeType, ? extends Vector, ?>>
implements Edge<NodeType> {
    protected int identifier;
    protected NodeType source;
    protected NodeType target;

    protected AbstractEdge() {
    }

    public AbstractEdge(int identifier) {
        this.identifier = identifier;
    }

    public AbstractEdge(int identifier, NodeType source, NodeType target) {
        this.identifier = identifier;
        this.source = source;
        this.target = target;
    }

    @Override
    public int getIdentifier() {
        return this.identifier;
    }

    @Override
    public void setIdentifier(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public NodeType getSource() {
        return this.source;
    }

    @Override
    public void setSource(NodeType source) {
        this.source = source;
    }

    @Override
    public NodeType getTarget() {
        return this.target;
    }

    @Override
    public void setTarget(NodeType target) {
        this.target = target;
    }

    @Override
    public boolean containsNode(NodeType node) {
        return this.source.equals(node) || this.target.equals(node);
    }

    public String toString() {
        return "Edge connecting " + this.source + " and " + this.target;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractEdge that = (AbstractEdge)o;
        return this.identifier == that.identifier;
    }

    public int hashCode() {
        return this.identifier;
    }
}

