/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.mathematics.geometry.faces;

import de.bioforscher.singa.mathematics.geometry.model.Polytope;
import de.bioforscher.singa.mathematics.vectors.Vector2D;
import de.bioforscher.singa.mathematics.vectors.Vectors;
import java.util.ArrayList;

public class SimplePolygon
implements Polytope<Vector2D> {
    private final Vector2D[] vertices;

    public SimplePolygon(Vector2D ... vertices) {
        this.vertices = vertices;
    }

    public SimplePolygon(ArrayList<Vector2D> vertices) {
        this(vertices.toArray(new Vector2D[0]));
    }

    public Vector2D[] getVertices() {
        return this.vertices;
    }

    @Override
    public Vector2D getVertex(int vertexIdentifier) {
        return this.vertices[vertexIdentifier];
    }

    public double getLeftMostXPosition() {
        return Vectors.getMinimalValueForIndex(0, this.getVertices());
    }

    public double getRightMostXPosition() {
        return Vectors.getMaximalValueForIndex(0, this.getVertices());
    }

    public double getBottomMostYPosition() {
        return Vectors.getMinimalValueForIndex(1, this.getVertices());
    }

    public double getTopMostYPosition() {
        return Vectors.getMaximalValueForIndex(1, this.getVertices());
    }

    public double getWidth() {
        return Math.abs(this.getRightMostXPosition() - this.getLeftMostXPosition());
    }

    public double getHeight() {
        return Math.abs(this.getTopMostYPosition() - this.getBottomMostYPosition());
    }

    public int getNumberOfVertices() {
        return this.vertices.length;
    }

    public int getNumberOfEdges() {
        return this.getNumberOfVertices();
    }

    public double getArea() {
        double sum = 0.0;
        for (int index = 0; index < this.getNumberOfVertices(); ++index) {
            int offsetIndex = (index + 1) % this.getNumberOfVertices();
            double m1 = this.getVertex(index).getX() * this.getVertex(offsetIndex).getY();
            double m2 = this.getVertex(offsetIndex).getX() * this.getVertex(index).getY();
            sum += m1 - m2;
        }
        return Math.abs(sum / 2.0);
    }

    public double getPerimeter() {
        double sum = 0.0;
        for (int index = 0; index < this.getNumberOfVertices(); ++index) {
            int offsetIndex = (index + 1) % this.getNumberOfVertices();
            double length = this.getVertex(index).distanceTo(this.getVertex(offsetIndex));
            sum += length;
        }
        return sum;
    }
}

