/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.mathematics.geometry.edges;

import de.bioforscher.singa.mathematics.geometry.edges.Line;
import de.bioforscher.singa.mathematics.metrics.model.VectorMetricProvider;
import de.bioforscher.singa.mathematics.vectors.Vector2D;

public class LineSegment
extends Line {
    private final Vector2D startingPoint;
    private final Vector2D endingPoint;

    public LineSegment(double x1, double y1, double x2, double y2) {
        this(new Vector2D(x1, y1), new Vector2D(x2, y2));
    }

    public LineSegment(Vector2D start, Vector2D end) {
        super(start, end);
        this.startingPoint = start;
        this.endingPoint = end;
    }

    public Vector2D getStartingPoint() {
        return this.startingPoint;
    }

    public Vector2D getEndingPoint() {
        return this.endingPoint;
    }

    @Override
    public double getXValue(double y) {
        if (y > this.getStartingPoint().getY() && y < this.getEndingPoint().getY() || y > this.getEndingPoint().getY() && y < this.getStartingPoint().getY()) {
            return super.getXValue(y);
        }
        return Double.NaN;
    }

    @Override
    public double getXIntercept() {
        if (this.getStartingPoint().getX() < 0.0 ^ this.getEndingPoint().getX() < 0.0) {
            return super.getXIntercept();
        }
        return Double.NaN;
    }

    @Override
    public double getYValue(double x) {
        if (x > this.getStartingPoint().getX() && x < this.getEndingPoint().getX() || x > this.getEndingPoint().getX() && x < this.getStartingPoint().getX()) {
            return super.getYValue(x);
        }
        return Double.NaN;
    }

    @Override
    public double getYIntercept() {
        if (this.getStartingPoint().getY() < 0.0 ^ this.getEndingPoint().getY() < 0.0) {
            return super.getYIntercept();
        }
        return Double.NaN;
    }

    public LineSegment getParallelSegment(double distance) {
        if (this.isHorizontal()) {
            return new LineSegment(this.startingPoint.getX(), this.startingPoint.getY() + distance, this.endingPoint.getX(), this.endingPoint.getY() + distance);
        }
        if (this.isVertical()) {
            return new LineSegment(this.startingPoint.getX() + distance, this.startingPoint.getY(), this.endingPoint.getX() + distance, this.endingPoint.getY());
        }
        Line parallel = this.getParallel(distance);
        Line perpendicularStart = new Line(this.startingPoint, parallel.getPerpendicularSlope());
        Line perpendicularEnd = new Line(this.endingPoint, parallel.getPerpendicularSlope());
        return new LineSegment(parallel.getInterceptWithLine(perpendicularStart), parallel.getInterceptWithLine(perpendicularEnd));
    }

    public Line getLineRepresentation() {
        return new Line(super.getYIntercept(), this.getSlope());
    }

    public Line calculatePerpendicularBisector() {
        Vector2D midAB = this.getStartingPoint().getMidpointTo(this.getEndingPoint());
        double slope = this.getPerpendicularSlope();
        double yIntercept = midAB.getY() - slope * midAB.getX();
        return new Line(midAB, new Vector2D(0.0, yIntercept));
    }

    public double getLength() {
        return VectorMetricProvider.EUCLIDEAN_METRIC.calculateDistance(this.startingPoint, this.endingPoint);
    }
}

