/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.mathematics.geometry.edges;

import de.bioforscher.singa.mathematics.vectors.Vector2D;

public class Line {
    private final double yIntercept;
    private final double slope;

    public Line(double yIntercept, double slope) {
        if (Double.isNaN(yIntercept)) {
            throw new IllegalArgumentException("Unable to create a new line with Double.NaN as intercept.");
        }
        if (Double.isNaN(slope)) {
            throw new IllegalArgumentException("Unable to create a new line with Double.NaN as slope.");
        }
        this.yIntercept = yIntercept;
        this.slope = slope;
    }

    public Line(Vector2D strutPoint, double slope) {
        if (!Double.isInfinite(slope)) {
            this.yIntercept = Line.calculateYIntercept(strutPoint, slope);
            this.slope = slope;
        } else {
            this.yIntercept = strutPoint.getX();
            this.slope = slope;
        }
    }

    public Line(double x1, double y1, double x2, double y2) {
        this(new Vector2D(x1, y1), new Vector2D(x2, y2));
    }

    public Line(Vector2D first, Vector2D second) {
        if (first.equals(second)) {
            throw new IllegalArgumentException("Unable to create line from two identical points: " + first + " and " + second + ".");
        }
        if (first.getX() == second.getX()) {
            this.slope = Double.POSITIVE_INFINITY;
            this.yIntercept = first.getX();
        } else {
            this.slope = Line.calculateSlope(first, second);
            this.yIntercept = Line.calculateYIntercept(first, this.slope);
        }
    }

    public static double calculateSlope(Vector2D first, Vector2D second) {
        if (first.getX() == second.getX()) {
            return Double.POSITIVE_INFINITY;
        }
        return (second.getY() - first.getY()) / (second.getX() - first.getX());
    }

    public static double calculateYIntercept(Vector2D first, double slope) {
        return first.getY() - first.getX() * slope;
    }

    public double getSlope() {
        return this.slope;
    }

    public double getXIntercept() {
        if (this.isVertical()) {
            return this.yIntercept;
        }
        return -this.getYIntercept() / this.getSlope();
    }

    public double getXValue(double y) {
        if (this.isVertical()) {
            return this.yIntercept;
        }
        return (y - this.getYIntercept()) / this.getSlope();
    }

    public double getYIntercept() {
        if (this.isVertical()) {
            return Double.NaN;
        }
        return this.yIntercept;
    }

    public double getYValue(double x) {
        return this.slope * x + this.yIntercept;
    }

    public double getAngleToXAxis() {
        return Math.atan(this.slope / 1.0);
    }

    public double getPerpendicularSlope() {
        return -1.0 / this.slope;
    }

    public Line getParallel(double distance) {
        if (this.isHorizontal()) {
            return new Line(this.yIntercept + distance, this.slope);
        }
        if (this.isVertical()) {
            return new Line(new Vector2D(this.yIntercept + distance, 0.0), Double.POSITIVE_INFINITY);
        }
        return new Line(this.yIntercept + distance * Math.sqrt(1.0 + this.slope * this.slope), this.slope);
    }

    public Vector2D getInterceptWithLine(Line line) {
        double a = this.slope;
        double b = line.getSlope();
        double c = this.getYIntercept();
        double d = line.getYIntercept();
        return new Vector2D((d - c) / (a - b), (a * d - b * c) / (a - b));
    }

    public Vector2D mirrorVector(Vector2D originalVector) {
        double d = (originalVector.getX() + (originalVector.getY() - this.getYIntercept()) * this.getSlope()) / (1.0 + this.getSlope() * this.getSlope());
        return new Vector2D(2.0 * d - originalVector.getX(), 2.0 * d * this.getSlope() - originalVector.getY() + 2.0 * this.yIntercept);
    }

    public boolean isHorizontal() {
        return this.slope == 0.0;
    }

    public boolean isVertical() {
        return Double.isInfinite(this.slope);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.slope);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.yIntercept);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Line other = (Line)obj;
        if (Double.doubleToLongBits(this.slope) != Double.doubleToLongBits(other.slope)) {
            return false;
        }
        return Double.doubleToLongBits(this.yIntercept) == Double.doubleToLongBits(other.yIntercept);
    }

    public String toString() {
        return "Line [yIntercept=" + this.getYIntercept() + ", slope=" + this.slope + "]";
    }
}

