/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.mathematics.algorithms.matrix;

import de.bioforscher.singa.mathematics.matrices.FastMatrices;
import de.bioforscher.singa.mathematics.matrices.Matrix;

public class SVDecomposition {
    private final Matrix matrixU;
    private final Matrix matrixV;
    private double[][] arrayInput;
    private double[][] arrayU;
    private double[][] arrayV;
    private double[] singularValues;
    private int rowDimension;
    private int columnDimension;
    private double[] e;
    private boolean wantu;
    private boolean wantv;
    private int nu;
    private double[] work;

    public SVDecomposition(Matrix matrix) {
        int i;
        double t;
        int k;
        int j;
        this.initialize(matrix);
        int nct = Math.min(this.rowDimension - 1, this.columnDimension);
        int nrt = Math.max(0, Math.min(this.columnDimension - 2, this.rowDimension));
        for (int k2 = 0; k2 < Math.max(nct, nrt); ++k2) {
            int i2;
            int i3;
            if (k2 < nct) {
                this.singularValues[k2] = 0.0;
                for (i3 = k2; i3 < this.rowDimension; ++i3) {
                    this.singularValues[k2] = SVDecomposition.hypot(this.singularValues[k2], this.arrayInput[i3][k2]);
                }
                if (this.singularValues[k2] != 0.0) {
                    if (this.arrayInput[k2][k2] < 0.0) {
                        this.singularValues[k2] = -this.singularValues[k2];
                    }
                    for (i3 = k2; i3 < this.rowDimension; ++i3) {
                        double[] dArray = this.arrayInput[i3];
                        int n = k2;
                        dArray[n] = dArray[n] / this.singularValues[k2];
                    }
                    double[] dArray = this.arrayInput[k2];
                    int n = k2;
                    dArray[n] = dArray[n] + 1.0;
                }
                this.singularValues[k2] = -this.singularValues[k2];
            }
            for (j = k2 + 1; j < this.columnDimension; ++j) {
                if (k2 < nct & this.singularValues[k2] != 0.0) {
                    double t2 = 0.0;
                    for (i2 = k2; i2 < this.rowDimension; ++i2) {
                        t2 += this.arrayInput[i2][k2] * this.arrayInput[i2][j];
                    }
                    t2 = -t2 / this.arrayInput[k2][k2];
                    for (i2 = k2; i2 < this.rowDimension; ++i2) {
                        double[] dArray = this.arrayInput[i2];
                        int n = j;
                        dArray[n] = dArray[n] + t2 * this.arrayInput[i2][k2];
                    }
                }
                this.e[j] = this.arrayInput[k2][j];
            }
            if (this.wantu & k2 < nct) {
                for (i3 = k2; i3 < this.rowDimension; ++i3) {
                    this.arrayU[i3][k2] = this.arrayInput[i3][k2];
                }
            }
            if (k2 >= nrt) continue;
            this.e[k2] = 0.0;
            for (i3 = k2 + 1; i3 < this.columnDimension; ++i3) {
                this.e[k2] = SVDecomposition.hypot(this.e[k2], this.e[i3]);
            }
            if (this.e[k2] != 0.0) {
                if (this.e[k2 + 1] < 0.0) {
                    this.e[k2] = -this.e[k2];
                }
                i3 = k2 + 1;
                while (i3 < this.columnDimension) {
                    int n = i3++;
                    this.e[n] = this.e[n] / this.e[k2];
                }
                int n = k2 + 1;
                this.e[n] = this.e[n] + 1.0;
            }
            this.e[k2] = -this.e[k2];
            if (k2 + 1 < this.rowDimension & this.e[k2] != 0.0) {
                for (i3 = k2 + 1; i3 < this.rowDimension; ++i3) {
                    this.work[i3] = 0.0;
                }
                for (j = k2 + 1; j < this.columnDimension; ++j) {
                    for (int i4 = k2 + 1; i4 < this.rowDimension; ++i4) {
                        int n = i4;
                        this.work[n] = this.work[n] + this.e[j] * this.arrayInput[i4][j];
                    }
                }
                for (j = k2 + 1; j < this.columnDimension; ++j) {
                    double t3 = -this.e[j] / this.e[k2 + 1];
                    for (i2 = k2 + 1; i2 < this.rowDimension; ++i2) {
                        double[] dArray = this.arrayInput[i2];
                        int n = j;
                        dArray[n] = dArray[n] + t3 * this.work[i2];
                    }
                }
            }
            if (!this.wantv) continue;
            for (i3 = k2 + 1; i3 < this.columnDimension; ++i3) {
                this.arrayV[i3][k2] = this.e[i3];
            }
        }
        int p = Math.min(this.columnDimension, this.rowDimension + 1);
        if (nct < this.columnDimension) {
            this.singularValues[nct] = this.arrayInput[nct][nct];
        }
        if (this.rowDimension < p) {
            this.singularValues[p - 1] = 0.0;
        }
        if (nrt + 1 < p) {
            this.e[nrt] = this.arrayInput[nrt][p - 1];
        }
        this.e[p - 1] = 0.0;
        if (this.wantu) {
            for (j = nct; j < this.nu; ++j) {
                for (int i5 = 0; i5 < this.rowDimension; ++i5) {
                    this.arrayU[i5][j] = 0.0;
                }
                this.arrayU[j][j] = 1.0;
            }
            for (k = nct - 1; k >= 0; --k) {
                int i6;
                if (this.singularValues[k] != 0.0) {
                    for (int j2 = k + 1; j2 < this.nu; ++j2) {
                        t = 0.0;
                        for (i = k; i < this.rowDimension; ++i) {
                            t += this.arrayU[i][k] * this.arrayU[i][j2];
                        }
                        t = -t / this.arrayU[k][k];
                        for (i = k; i < this.rowDimension; ++i) {
                            double[] dArray = this.arrayU[i];
                            int n = j2;
                            dArray[n] = dArray[n] + t * this.arrayU[i][k];
                        }
                    }
                    for (i6 = k; i6 < this.rowDimension; ++i6) {
                        this.arrayU[i6][k] = -this.arrayU[i6][k];
                    }
                    this.arrayU[k][k] = 1.0 + this.arrayU[k][k];
                    for (i6 = 0; i6 < k - 1; ++i6) {
                        this.arrayU[i6][k] = 0.0;
                    }
                    continue;
                }
                for (i6 = 0; i6 < this.rowDimension; ++i6) {
                    this.arrayU[i6][k] = 0.0;
                }
                this.arrayU[k][k] = 1.0;
            }
        }
        if (this.wantv) {
            for (k = this.columnDimension - 1; k >= 0; --k) {
                if (k < nrt & this.e[k] != 0.0) {
                    for (int j3 = k + 1; j3 < this.nu; ++j3) {
                        t = 0.0;
                        for (i = k + 1; i < this.columnDimension; ++i) {
                            t += this.arrayV[i][k] * this.arrayV[i][j3];
                        }
                        t = -t / this.arrayV[k + 1][k];
                        for (i = k + 1; i < this.columnDimension; ++i) {
                            double[] dArray = this.arrayV[i];
                            int n = j3;
                            dArray[n] = dArray[n] + t * this.arrayV[i][k];
                        }
                    }
                }
                for (int i7 = 0; i7 < this.columnDimension; ++i7) {
                    this.arrayV[i7][k] = 0.0;
                }
                this.arrayV[k][k] = 1.0;
            }
        }
        int pp = p - 1;
        int iter = 0;
        double eps = Math.pow(2.0, -52.0);
        double tiny = Math.pow(2.0, -966.0);
        block35: while (p > 0) {
            int kase;
            int k3;
            for (k3 = p - 2; k3 >= -1 && k3 != -1; --k3) {
                if (!(Math.abs(this.e[k3]) <= tiny + eps * (Math.abs(this.singularValues[k3]) + Math.abs(this.singularValues[k3 + 1])))) continue;
                this.e[k3] = 0.0;
                break;
            }
            if (k3 == p - 2) {
                kase = 4;
            } else {
                int ks;
                for (ks = p - 1; ks >= k3 && ks != k3; --ks) {
                    double t4 = (ks != p ? Math.abs(this.e[ks]) : 0.0) + (ks != k3 + 1 ? Math.abs(this.e[ks - 1]) : 0.0);
                    if (!(Math.abs(this.singularValues[ks]) <= tiny + eps * t4)) continue;
                    this.singularValues[ks] = 0.0;
                    break;
                }
                if (ks == k3) {
                    kase = 3;
                } else if (ks == p - 1) {
                    kase = 1;
                } else {
                    kase = 2;
                    k3 = ks;
                }
            }
            ++k3;
            switch (kase) {
                case 1: {
                    int i8;
                    double sn;
                    double cs;
                    double t5;
                    double f = this.e[p - 2];
                    this.e[p - 2] = 0.0;
                    for (int j4 = p - 2; j4 >= k3; --j4) {
                        t5 = SVDecomposition.hypot(this.singularValues[j4], f);
                        cs = this.singularValues[j4] / t5;
                        sn = f / t5;
                        this.singularValues[j4] = t5;
                        if (j4 != k3) {
                            f = -sn * this.e[j4 - 1];
                            this.e[j4 - 1] = cs * this.e[j4 - 1];
                        }
                        if (!this.wantv) continue;
                        for (i8 = 0; i8 < this.columnDimension; ++i8) {
                            t5 = cs * this.arrayV[i8][j4] + sn * this.arrayV[i8][p - 1];
                            this.arrayV[i8][p - 1] = -sn * this.arrayV[i8][j4] + cs * this.arrayV[i8][p - 1];
                            this.arrayV[i8][j4] = t5;
                        }
                    }
                    continue block35;
                }
                case 2: {
                    int i8;
                    double sn;
                    double cs;
                    double t5;
                    double f = this.e[k3 - 1];
                    this.e[k3 - 1] = 0.0;
                    for (int j5 = k3; j5 < p; ++j5) {
                        t5 = SVDecomposition.hypot(this.singularValues[j5], f);
                        cs = this.singularValues[j5] / t5;
                        sn = f / t5;
                        this.singularValues[j5] = t5;
                        f = -sn * this.e[j5];
                        this.e[j5] = cs * this.e[j5];
                        if (!this.wantu) continue;
                        for (i8 = 0; i8 < this.rowDimension; ++i8) {
                            t5 = cs * this.arrayU[i8][j5] + sn * this.arrayU[i8][k3 - 1];
                            this.arrayU[i8][k3 - 1] = -sn * this.arrayU[i8][j5] + cs * this.arrayU[i8][k3 - 1];
                            this.arrayU[i8][j5] = t5;
                        }
                    }
                    continue block35;
                }
                case 3: {
                    double scale = Math.max(Math.max(Math.max(Math.max(Math.abs(this.singularValues[p - 1]), Math.abs(this.singularValues[p - 2])), Math.abs(this.e[p - 2])), Math.abs(this.singularValues[k3])), Math.abs(this.e[k3]));
                    double sp = this.singularValues[p - 1] / scale;
                    double spm1 = this.singularValues[p - 2] / scale;
                    double epm1 = this.e[p - 2] / scale;
                    double sk = this.singularValues[k3] / scale;
                    double ek = this.e[k3] / scale;
                    double b = ((spm1 + sp) * (spm1 - sp) + epm1 * epm1) / 2.0;
                    double c = sp * epm1 * (sp * epm1);
                    double shift = 0.0;
                    if (b != 0.0 | c != 0.0) {
                        shift = Math.sqrt(b * b + c);
                        if (b < 0.0) {
                            shift = -shift;
                        }
                        shift = c / (b + shift);
                    }
                    double f = (sk + sp) * (sk - sp) + shift;
                    double g = sk * ek;
                    for (int j6 = k3; j6 < p - 1; ++j6) {
                        int i9;
                        double t6 = SVDecomposition.hypot(f, g);
                        double cs = f / t6;
                        double sn = g / t6;
                        if (j6 != k3) {
                            this.e[j6 - 1] = t6;
                        }
                        f = cs * this.singularValues[j6] + sn * this.e[j6];
                        this.e[j6] = cs * this.e[j6] - sn * this.singularValues[j6];
                        g = sn * this.singularValues[j6 + 1];
                        this.singularValues[j6 + 1] = cs * this.singularValues[j6 + 1];
                        if (this.wantv) {
                            for (i9 = 0; i9 < this.columnDimension; ++i9) {
                                t6 = cs * this.arrayV[i9][j6] + sn * this.arrayV[i9][j6 + 1];
                                this.arrayV[i9][j6 + 1] = -sn * this.arrayV[i9][j6] + cs * this.arrayV[i9][j6 + 1];
                                this.arrayV[i9][j6] = t6;
                            }
                        }
                        t6 = SVDecomposition.hypot(f, g);
                        cs = f / t6;
                        sn = g / t6;
                        this.singularValues[j6] = t6;
                        f = cs * this.e[j6] + sn * this.singularValues[j6 + 1];
                        this.singularValues[j6 + 1] = -sn * this.e[j6] + cs * this.singularValues[j6 + 1];
                        g = sn * this.e[j6 + 1];
                        this.e[j6 + 1] = cs * this.e[j6 + 1];
                        if (!this.wantu || j6 >= this.rowDimension - 1) continue;
                        for (i9 = 0; i9 < this.rowDimension; ++i9) {
                            t6 = cs * this.arrayU[i9][j6] + sn * this.arrayU[i9][j6 + 1];
                            this.arrayU[i9][j6 + 1] = -sn * this.arrayU[i9][j6] + cs * this.arrayU[i9][j6 + 1];
                            this.arrayU[i9][j6] = t6;
                        }
                    }
                    this.e[p - 2] = f;
                    ++iter;
                    break;
                }
                case 4: {
                    if (this.singularValues[k3] <= 0.0) {
                        double d = this.singularValues[k3] = this.singularValues[k3] < 0.0 ? -this.singularValues[k3] : 0.0;
                        if (this.wantv) {
                            for (int i10 = 0; i10 <= pp; ++i10) {
                                this.arrayV[i10][k3] = -this.arrayV[i10][k3];
                            }
                        }
                    }
                    while (k3 < pp && !(this.singularValues[k3] >= this.singularValues[k3 + 1])) {
                        int i11;
                        double t7 = this.singularValues[k3];
                        this.singularValues[k3] = this.singularValues[k3 + 1];
                        this.singularValues[k3 + 1] = t7;
                        if (this.wantv && k3 < this.columnDimension - 1) {
                            for (i11 = 0; i11 < this.columnDimension; ++i11) {
                                t7 = this.arrayV[i11][k3 + 1];
                                this.arrayV[i11][k3 + 1] = this.arrayV[i11][k3];
                                this.arrayV[i11][k3] = t7;
                            }
                        }
                        if (this.wantu && k3 < this.rowDimension - 1) {
                            for (i11 = 0; i11 < this.rowDimension; ++i11) {
                                t7 = this.arrayU[i11][k3 + 1];
                                this.arrayU[i11][k3 + 1] = this.arrayU[i11][k3];
                                this.arrayU[i11][k3] = t7;
                            }
                        }
                        ++k3;
                    }
                    iter = 0;
                    --p;
                }
            }
        }
        this.matrixU = FastMatrices.createRegularMatrix(this.arrayU);
        this.matrixV = FastMatrices.createRegularMatrix(this.arrayV);
    }

    private static double hypot(double a, double b) {
        double r;
        if (Math.abs(a) > Math.abs(b)) {
            r = b / a;
            r = Math.abs(a) * Math.sqrt(1.0 + r * r);
        } else if (b != 0.0) {
            r = a / b;
            r = Math.abs(b) * Math.sqrt(1.0 + r * r);
        } else {
            r = 0.0;
        }
        return r;
    }

    public Matrix getMatrixU() {
        return this.matrixU;
    }

    public Matrix getMatrixV() {
        return this.matrixV;
    }

    private void initialize(Matrix matrix) {
        this.arrayInput = matrix.getCopy().getElements();
        this.rowDimension = matrix.getRowDimension();
        this.columnDimension = matrix.getColumnDimension();
        this.nu = Math.min(this.rowDimension, this.columnDimension);
        this.singularValues = new double[Math.min(this.rowDimension + 1, this.columnDimension)];
        this.arrayU = new double[this.rowDimension][this.nu];
        this.arrayV = new double[this.columnDimension][this.columnDimension];
        this.e = new double[this.columnDimension];
        this.work = new double[this.rowDimension];
        this.wantu = true;
        this.wantv = true;
    }

    public double[][] getArrayV() {
        return this.arrayV;
    }

    public double[] getSingularValues() {
        return this.singularValues;
    }
}

