/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.mathematics.algorithms.graphs;

import de.bioforscher.singa.mathematics.graphs.model.Node;
import de.bioforscher.singa.mathematics.vectors.Vector;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.function.Predicate;

public class ShortestPathFinder<NodeType extends Node<NodeType, VectorType, IdentifierType>, VectorType extends Vector, IdentifierType> {
    private Queue<NodeType> queue;
    private Map<NodeType, Integer> distances = new HashMap<NodeType, Integer>();
    private Map<NodeType, NodeType> predecessors = new HashMap<NodeType, NodeType>();

    private ShortestPathFinder(NodeType sourceNode) {
        this.queue = new LinkedList<NodeType>();
        this.queue.offer(sourceNode);
        this.distances.put(sourceNode, 0);
    }

    public static <NodeType extends Node<NodeType, VectorType, IdentifierType>, VectorType extends Vector, IdentifierType> LinkedList<NodeType> findBasedOnPredicate(NodeType sourceNode, Predicate<NodeType> targetPredicate) {
        ShortestPathFinder<NodeType, VectorType, IdentifierType> pathfinder = new ShortestPathFinder<NodeType, VectorType, IdentifierType>(sourceNode);
        while (!pathfinder.queue.isEmpty()) {
            Node currentNode = (Node)pathfinder.queue.poll();
            for (Node neighbour : currentNode.getNeighbours()) {
                LinkedList<Node> path = super.checkTarget(currentNode, neighbour, targetPredicate);
                if (path == null) continue;
                return path;
            }
        }
        return null;
    }

    public static <NodeType extends Node<NodeType, VectorType, IdentifierType>, VectorType extends Vector, IdentifierType> LinkedList<NodeType> trackBasedOnPredicates(NodeType sourceNode, Predicate<NodeType> targetPredicate, Predicate<NodeType> trackPredicate) {
        ShortestPathFinder<NodeType, VectorType, IdentifierType> pathfinder = new ShortestPathFinder<NodeType, VectorType, IdentifierType>(sourceNode);
        while (!pathfinder.queue.isEmpty()) {
            Node currentNode = (Node)pathfinder.queue.poll();
            for (Node neighbour : currentNode.getNeighbours()) {
                LinkedList<Node> path;
                if (!trackPredicate.test(currentNode) || (path = super.checkTarget(currentNode, neighbour, targetPredicate)) == null) continue;
                return path;
            }
        }
        return null;
    }

    private LinkedList<NodeType> checkTarget(NodeType source, NodeType target, Predicate<NodeType> targetPredicate) {
        if (!this.distances.containsKey(target)) {
            if (targetPredicate.test(target)) {
                this.predecessors.put(target, source);
                return this.getPath(target);
            }
            this.distances.put(target, this.distances.get(source) + 1);
            this.predecessors.put(target, source);
            this.queue.offer(target);
        }
        return null;
    }

    private LinkedList<NodeType> getPath(NodeType targetNode) {
        LinkedList<NodeType> path = new LinkedList<NodeType>();
        Object step = targetNode;
        if (this.predecessors.get(step) == null) {
            return null;
        }
        path.add(step);
        while (this.predecessors.get(step) != null) {
            step = (Node)this.predecessors.get(step);
            path.add(step);
        }
        Collections.reverse(path);
        return path;
    }
}

