/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.mathematics.algorithms.geometry;

import de.bioforscher.singa.mathematics.vectors.Vector2D;
import de.bioforscher.singa.mathematics.vectors.Vectors;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.List;
import java.util.stream.Collectors;

public class ConvexHull {
    private List<Vector2D> vectors;
    private Deque<Vector2D> stack;

    public ConvexHull(Collection<Vector2D> vectors) {
        this.vectors = new ArrayList<Vector2D>(vectors);
        this.stack = new ArrayDeque<Vector2D>();
    }

    public static ConvexHull calculateHullFor(Collection<Vector2D> vectors) {
        ConvexHull convexHull = new ConvexHull(vectors);
        List<Vector2D> vectorsWithMinimalY = Vectors.getVectorsWithMinimalValueForIndex(convexHull.vectors, 1);
        Vector2D referenceVector = Vectors.getVectorsWithMinimalValueForIndex(vectorsWithMinimalY, 1).iterator().next();
        convexHull.vectors.sort(Comparator.comparing(vector -> {
            double deltaY = referenceVector.getY() - vector.getY();
            double deltaX = referenceVector.getX() - vector.getX();
            return Math.atan2(deltaY, deltaX);
        }, Comparator.reverseOrder()));
        convexHull.stack.push(convexHull.vectors.get(0));
        convexHull.stack.push(convexHull.vectors.get(1));
        convexHull.stack.push(convexHull.vectors.get(2));
        int totalIterations = vectors.size();
        for (int currentIndex = 3; currentIndex < totalIterations; ++currentIndex) {
            while (ConvexHull.getTurnDirection(convexHull.peekTop(), convexHull.peekNextToTop(), convexHull.vectors.get(currentIndex)) == TurnDirection.CLOCKWISE) {
                convexHull.stack.pop();
            }
            convexHull.stack.push(convexHull.vectors.get(currentIndex));
        }
        convexHull.stack.push(convexHull.vectors.get(0));
        return convexHull;
    }

    private Vector2D peekTop() {
        return this.stack.peek();
    }

    private Vector2D peekNextToTop() {
        Vector2D top = this.stack.pop();
        Vector2D nextToTop = this.stack.peek();
        this.stack.push(top);
        return nextToTop;
    }

    public List<Vector2D> getAllVectors() {
        return this.vectors;
    }

    public List<Vector2D> getHull() {
        return new ArrayList<Vector2D>(this.stack);
    }

    public List<Vector2D> getNonHullVectors() {
        return this.vectors.stream().filter(vector -> !this.getHull().contains(vector)).collect(Collectors.toList());
    }

    private static TurnDirection getTurnDirection(Vector2D first, Vector2D second, Vector2D third) {
        double direction = (second.getX() - first.getX()) * (third.getY() - first.getY()) - (second.getY() - first.getY()) * (third.getX() - first.getX());
        if (direction > 0.0) {
            return TurnDirection.COUNTER_CLOCKWISE;
        }
        if (direction < 0.0) {
            return TurnDirection.CLOCKWISE;
        }
        return TurnDirection.COLINEAR;
    }

    private static enum TurnDirection {
        COUNTER_CLOCKWISE,
        CLOCKWISE,
        COLINEAR;

    }
}

