/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.javafx.voronoi;

import de.bioforscher.singa.javafx.renderer.Renderer;
import de.bioforscher.singa.mathematics.algorithms.voronoi.VoronoiGenerator;
import de.bioforscher.singa.mathematics.algorithms.voronoi.VoronoiRelaxation;
import de.bioforscher.singa.mathematics.algorithms.voronoi.model.VoronoiCell;
import de.bioforscher.singa.mathematics.algorithms.voronoi.model.VoronoiDiagram;
import de.bioforscher.singa.mathematics.geometry.faces.Rectangle;
import de.bioforscher.singa.mathematics.geometry.model.Polygon;
import de.bioforscher.singa.mathematics.vectors.Vector2D;
import de.bioforscher.singa.mathematics.vectors.Vectors;
import java.util.Collection;
import java.util.List;
import javafx.application.Application;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Button;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;

public class VoronoiPlayground
extends Application
implements Renderer {
    private Canvas canvas;
    private VoronoiDiagram diagram;
    private List<Vector2D> points;

    public static void main(String[] args) {
        VoronoiPlayground.launch((String[])new String[0]);
    }

    public void start(Stage primaryStage) throws Exception {
        BorderPane root = new BorderPane();
        this.canvas = new Canvas(700.0, 700.0);
        this.canvas.setOnMouseClicked(this::handleCanvasClick);
        root.setCenter((Node)this.canvas);
        HBox buttonBar = new HBox();
        Button pointsButton = new Button("Generate points");
        pointsButton.setOnAction(this::generatePoints);
        Button voronoiButton = new Button("Generate Voronoi");
        voronoiButton.setOnAction(this::generateVoronoi);
        Button relaxButton = new Button("Relax sites");
        relaxButton.setOnAction(this::relaxSites);
        buttonBar.getChildren().addAll((Object[])new Node[]{pointsButton, voronoiButton, relaxButton});
        root.setBottom((Node)buttonBar);
        Scene scene = new Scene((Parent)root);
        primaryStage.setScene(scene);
        primaryStage.show();
    }

    @Override
    public GraphicsContext getGraphicsContext() {
        return this.canvas.getGraphicsContext2D();
    }

    @Override
    public double getDrawingWidth() {
        return this.canvas.getWidth();
    }

    @Override
    public double getDrawingHeight() {
        return this.canvas.getHeight();
    }

    private void handleCanvasClick(MouseEvent event) {
        Vector2D clickPosition = new Vector2D(event.getX(), event.getY());
        for (VoronoiCell voronoiCell : this.diagram.getCells()) {
            if (voronoiCell.evaluatePointPosition(clickPosition) != VoronoiCell.INSIDE) continue;
            this.getGraphicsContext().setFill((Paint)Color.INDIANRED);
            this.fillPolygon((Polygon)voronoiCell);
            break;
        }
    }

    private void generatePoints(ActionEvent event) {
        this.diagram = null;
        this.points = Vectors.generateMultipleRandom2DVectors((int)50, (Rectangle)new Rectangle(this.getDrawingWidth(), this.getDrawingHeight()));
        this.clearCanvas();
        this.drawPoints();
    }

    private void generateVoronoi(ActionEvent event) {
        if (this.points != null) {
            this.diagram = VoronoiGenerator.generateVoronoiDiagram(this.points, (Rectangle)new Rectangle(this.getDrawingWidth(), this.getDrawingHeight()));
            this.clearCanvas();
            this.drawDiagram();
            this.drawPoints();
        }
    }

    private void relaxSites(ActionEvent event) {
        if (this.points != null && this.diagram != null) {
            this.diagram = VoronoiGenerator.generateVoronoiDiagram((Collection)VoronoiRelaxation.relax((VoronoiDiagram)this.diagram), (Rectangle)new Rectangle(this.getDrawingWidth(), this.getDrawingHeight()));
            this.points = this.diagram.getSites();
            this.clearCanvas();
            this.drawPoints();
            this.drawDiagram();
        }
    }

    private void clearCanvas() {
        this.getGraphicsContext().setFill((Paint)Color.WHITE);
        this.drawRectangle(new Vector2D(0.0, 0.0), new Vector2D(this.getDrawingWidth(), this.getDrawingHeight()));
    }

    private void drawDiagram() {
        this.getGraphicsContext().setStroke((Paint)Color.TOMATO);
        this.getGraphicsContext().setLineWidth(4.0);
        this.diagram.getEdges().forEach(edge -> this.drawStraight(edge.getStartingPoint(), edge.getEndingPoint()));
        this.getGraphicsContext().setLineWidth(6.0);
        this.getGraphicsContext().setFill((Paint)Color.DARKRED);
        this.diagram.getVertices().forEach(this::drawPoint);
    }

    private void drawPoints() {
        this.getGraphicsContext().setFill((Paint)Color.DARKRED);
        this.getGraphicsContext().setLineWidth(4.0);
        this.points.forEach(this::drawPoint);
    }
}

