/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.javafx.viewer;

import de.bioforscher.singa.javafx.renderer.graphs.GraphDisplayApplication;
import de.bioforscher.singa.javafx.renderer.graphs.GraphRenderer;
import de.bioforscher.singa.mathematics.algorithms.graphs.isomorphism.RISubgraphFinder;
import de.bioforscher.singa.mathematics.graphs.model.DirectedGraph;
import de.bioforscher.singa.mathematics.graphs.model.GenericNode;
import de.bioforscher.singa.mathematics.graphs.model.Node;
import de.bioforscher.singa.mathematics.vectors.Vector2D;
import javafx.application.Application;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class TestGraphViewer {
    public static void main(String[] args) {
        DirectedGraph searchSpace;
        DirectedGraph targetGraph = new DirectedGraph();
        GenericNode targetNode1 = new GenericNode(targetGraph.nextNodeIdentifier().intValue(), (Object)"circle");
        targetGraph.addNode((Node)targetNode1);
        GenericNode targetNode2 = new GenericNode(targetGraph.nextNodeIdentifier().intValue(), (Object)"square");
        targetGraph.addNode((Node)targetNode2);
        GenericNode targetNode3 = new GenericNode(targetGraph.nextNodeIdentifier().intValue(), (Object)"triangle");
        targetGraph.addNode((Node)targetNode3);
        targetGraph.addEdgeBetween((Node)targetNode1, (Node)targetNode2);
        targetGraph.addEdgeBetween((Node)targetNode2, (Node)targetNode1);
        targetGraph.addEdgeBetween((Node)targetNode2, (Node)targetNode3);
        targetGraph.addEdgeBetween((Node)targetNode3, (Node)targetNode2);
        targetGraph.addEdgeBetween((Node)targetNode3, (Node)targetNode1);
        targetGraph.addEdgeBetween((Node)targetNode1, (Node)targetNode3);
        DirectedGraph patternGraph = new DirectedGraph();
        GenericNode patternNode1 = new GenericNode(patternGraph.nextNodeIdentifier().intValue(), (Object)"circle");
        patternGraph.addNode((Node)patternNode1);
        GenericNode patternNode2 = new GenericNode(patternGraph.nextNodeIdentifier().intValue(), (Object)"square");
        patternGraph.addNode((Node)patternNode2);
        patternGraph.addEdgeBetween((Node)patternNode1, (Node)patternNode2);
        patternGraph.addEdgeBetween((Node)patternNode2, (Node)patternNode1);
        RISubgraphFinder finder = new RISubgraphFinder(TestGraphViewer.createPatternGraph(), TestGraphViewer.createTargetGraph(), (a, b) -> ((String)a.getContent()).equals(b.getContent()), (a, b) -> true);
        GraphDisplayApplication.graph = searchSpace = finder.getSearchSpace();
        GraphRenderer renderer = GraphDisplayApplication.renderer;
        renderer.setRenderAfter(graph -> {
            for (GenericNode genericNodeGenericNode : searchSpace.getNodes()) {
                renderer.getGraphicsContext().setFill((Paint)Color.SEAGREEN);
                renderer.drawPoint((Vector2D)genericNodeGenericNode.getPosition(), 25.0);
                renderer.getGraphicsContext().setFill((Paint)Color.BLACK);
                GenericNode content = (GenericNode)genericNodeGenericNode.getContent();
                if (content == null) continue;
                renderer.drawTextCenteredOnPoint((String)content.getContent(), (Vector2D)genericNodeGenericNode.getPosition());
            }
            return null;
        });
        Application.launch(GraphDisplayApplication.class, (String[])new String[0]);
    }

    private static DirectedGraph<GenericNode<String>> createPatternGraph() {
        DirectedGraph patternGraph = new DirectedGraph();
        GenericNode patternNode0 = new GenericNode(patternGraph.nextNodeIdentifier().intValue(), (Object)"0");
        patternGraph.addNode((Node)patternNode0);
        GenericNode patternNode3 = new GenericNode(patternGraph.nextNodeIdentifier().intValue(), (Object)"3");
        patternGraph.addNode((Node)patternNode3);
        GenericNode patternNode4 = new GenericNode(patternGraph.nextNodeIdentifier().intValue(), (Object)"4");
        patternGraph.addNode((Node)patternNode4);
        GenericNode patternNode6 = new GenericNode(patternGraph.nextNodeIdentifier().intValue(), (Object)"6");
        patternGraph.addNode((Node)patternNode6);
        GenericNode patternNode7 = new GenericNode(patternGraph.nextNodeIdentifier().intValue(), (Object)"7");
        patternGraph.addNode((Node)patternNode7);
        patternGraph.addEdgeBetween((Node)patternNode0, (Node)patternNode3);
        patternGraph.addEdgeBetween((Node)patternNode3, (Node)patternNode0);
        patternGraph.addEdgeBetween((Node)patternNode3, (Node)patternNode6);
        patternGraph.addEdgeBetween((Node)patternNode6, (Node)patternNode3);
        patternGraph.addEdgeBetween((Node)patternNode0, (Node)patternNode4);
        patternGraph.addEdgeBetween((Node)patternNode4, (Node)patternNode0);
        patternGraph.addEdgeBetween((Node)patternNode4, (Node)patternNode6);
        patternGraph.addEdgeBetween((Node)patternNode6, (Node)patternNode4);
        patternGraph.addEdgeBetween((Node)patternNode6, (Node)patternNode7);
        patternGraph.addEdgeBetween((Node)patternNode7, (Node)patternNode6);
        return patternGraph;
    }

    private static DirectedGraph<GenericNode<String>> createTargetGraph() {
        DirectedGraph targetGraph = new DirectedGraph();
        GenericNode patternNode0 = new GenericNode(targetGraph.nextNodeIdentifier().intValue(), (Object)"0");
        targetGraph.addNode((Node)patternNode0);
        GenericNode patternNode1 = new GenericNode(targetGraph.nextNodeIdentifier().intValue(), (Object)"1");
        targetGraph.addNode((Node)patternNode1);
        GenericNode patternNode2 = new GenericNode(targetGraph.nextNodeIdentifier().intValue(), (Object)"2");
        targetGraph.addNode((Node)patternNode2);
        GenericNode patternNode3 = new GenericNode(targetGraph.nextNodeIdentifier().intValue(), (Object)"3");
        targetGraph.addNode((Node)patternNode3);
        GenericNode patternNode4 = new GenericNode(targetGraph.nextNodeIdentifier().intValue(), (Object)"4");
        targetGraph.addNode((Node)patternNode4);
        GenericNode patternNode5 = new GenericNode(targetGraph.nextNodeIdentifier().intValue(), (Object)"5");
        targetGraph.addNode((Node)patternNode5);
        GenericNode patternNode6 = new GenericNode(targetGraph.nextNodeIdentifier().intValue(), (Object)"6");
        targetGraph.addNode((Node)patternNode6);
        GenericNode patternNode7 = new GenericNode(targetGraph.nextNodeIdentifier().intValue(), (Object)"7");
        targetGraph.addNode((Node)patternNode7);
        GenericNode patternNode8 = new GenericNode(targetGraph.nextNodeIdentifier().intValue(), (Object)"8");
        targetGraph.addNode((Node)patternNode8);
        GenericNode patternNode9 = new GenericNode(targetGraph.nextNodeIdentifier().intValue(), (Object)"9");
        targetGraph.addNode((Node)patternNode9);
        GenericNode patternNode10 = new GenericNode(targetGraph.nextNodeIdentifier().intValue(), (Object)"10");
        targetGraph.addNode((Node)patternNode10);
        targetGraph.addEdgeBetween((Node)patternNode0, (Node)patternNode1);
        targetGraph.addEdgeBetween((Node)patternNode1, (Node)patternNode0);
        targetGraph.addEdgeBetween((Node)patternNode1, (Node)patternNode2);
        targetGraph.addEdgeBetween((Node)patternNode2, (Node)patternNode1);
        targetGraph.addEdgeBetween((Node)patternNode0, (Node)patternNode3);
        targetGraph.addEdgeBetween((Node)patternNode3, (Node)patternNode0);
        targetGraph.addEdgeBetween((Node)patternNode3, (Node)patternNode6);
        targetGraph.addEdgeBetween((Node)patternNode6, (Node)patternNode3);
        targetGraph.addEdgeBetween((Node)patternNode6, (Node)patternNode7);
        targetGraph.addEdgeBetween((Node)patternNode7, (Node)patternNode6);
        targetGraph.addEdgeBetween((Node)patternNode7, (Node)patternNode8);
        targetGraph.addEdgeBetween((Node)patternNode8, (Node)patternNode7);
        targetGraph.addEdgeBetween((Node)patternNode5, (Node)patternNode8);
        targetGraph.addEdgeBetween((Node)patternNode8, (Node)patternNode5);
        targetGraph.addEdgeBetween((Node)patternNode2, (Node)patternNode5);
        targetGraph.addEdgeBetween((Node)patternNode5, (Node)patternNode2);
        targetGraph.addEdgeBetween((Node)patternNode0, (Node)patternNode4);
        targetGraph.addEdgeBetween((Node)patternNode4, (Node)patternNode0);
        targetGraph.addEdgeBetween((Node)patternNode4, (Node)patternNode6);
        targetGraph.addEdgeBetween((Node)patternNode6, (Node)patternNode4);
        targetGraph.addEdgeBetween((Node)patternNode1, (Node)patternNode4);
        targetGraph.addEdgeBetween((Node)patternNode4, (Node)patternNode1);
        targetGraph.addEdgeBetween((Node)patternNode4, (Node)patternNode7);
        targetGraph.addEdgeBetween((Node)patternNode7, (Node)patternNode4);
        targetGraph.addEdgeBetween((Node)patternNode5, (Node)patternNode4);
        targetGraph.addEdgeBetween((Node)patternNode4, (Node)patternNode5);
        targetGraph.addEdgeBetween((Node)patternNode1, (Node)patternNode5);
        targetGraph.addEdgeBetween((Node)patternNode5, (Node)patternNode1);
        targetGraph.addEdgeBetween((Node)patternNode5, (Node)patternNode7);
        targetGraph.addEdgeBetween((Node)patternNode7, (Node)patternNode5);
        targetGraph.addEdgeBetween((Node)patternNode0, (Node)patternNode9);
        targetGraph.addEdgeBetween((Node)patternNode9, (Node)patternNode0);
        targetGraph.addEdgeBetween((Node)patternNode9, (Node)patternNode6);
        targetGraph.addEdgeBetween((Node)patternNode6, (Node)patternNode9);
        targetGraph.addEdgeBetween((Node)patternNode10, (Node)patternNode9);
        targetGraph.addEdgeBetween((Node)patternNode9, (Node)patternNode10);
        return targetGraph;
    }
}

